DShistogram <-
  function(XX,limx=NA,npart=10,nl=101,pic=TRUE,pdf=FALSE){
    #function makes a partition of the interval stated in xlim of nbreaks elements
    #XX...fuzzy sample (list as always)
    #xlim...limits of the histrogram - if NA then the max and min of the supps will be taken
    #nl...number of levels
    #make use of frequency function
    #construct 2 dim matrix and use 3d plot via persp and contour plot
    
    #construct limits
    if(length(limx)<=1|limx[2]<=limx[1]){
      a<-XX[[1]]$x[1]
      b<-XX[[1]]$x[nrow(XX[[1]])]
      if(length(XX)>1){
        for (i in 2:length(XX)){
          a<-min(a,XX[[i]]$x[1])
          b<-max(b,XX[[i]]$x[nrow(XX[[i]])])
        }
      }
      limx<-c(a,b) 
    }
    
    k<-length(XX)
    if(k>500){
      ygrid<-seq(0,1,length=501)
    }
    if(k<=500){
      ygrid<-sort(union(seq(0,1,length=(k+1)),seq(0,1,length=101)))
    }
    
    breaks<-seq(limx[1],limx[2],length=npart+1)
    FR<-vector("list",length=npart)
    FR2<-vector("list",length=npart)
    for (i in 1:npart){
      FR[[i]]<-DSfrequency(XX,breaks[i:(i+1)],0,nl)
      print(i)
      R<-FR[[i]][(nl+1):(2*nl),]
      a<-approx(R$x,R$alpha,xout=ygrid,yleft=R$alpha[1],yright=R$alpha[nl],
                method="constant",f=1,ties="max")
      L<-FR[[i]][1:nl,]
      b<-approx(L$x,L$alpha,xout=ygrid,yleft=L$alpha[1],yright=L$alpha[nl],
                method="constant",f=0,ties="max") 
      
      value<-ifelse(a$y>=b$y,b$y,a$y) 
      FR2[[i]]<-data.frame(x=ygrid,y=value)
    }
    #construct grid for y-coordinate in plotting
    grid1<-breaks+(breaks[2]-breaks[1])/1000
    grid2<-breaks-(breaks[2]-breaks[1])/1000
    grid3<-c(grid1,grid2)
    grid3<-sort(subset(grid3,grid3>=min(breaks)&grid3<=max(breaks)))
    gridx<-grid3
    
    gridy<-ygrid
    M<-matrix(numeric(npart*length(gridy)),ncol=length(gridy))
    for (i in 1:npart){
      M[i,]<-FR2[[i]]$y
    }
    
    M2<-M[rep(1:npart, rep(2,npart)),]
    
    k<-length(XX)
    lower<-rep(0,k)
    upper<-lower
    for (j in 1:k){
      lower[j]<-min(XX[[j]])
      upper[j]<-max(XX[[j]])
    }
    lim_temp<-c(min(lower),max(upper))
    
    if(pdf==TRUE){
      pdf(file="histo.pdf",width=12,height=8)
      #BBreaks<-list(length=length(breaks))
      #for (m in 1:length(breaks)){
      # BBreaks[[m]]<-data.frame(x=rep(breaks[m],2),alpha=c(-0.05,1.05))
      #}
      #plot(XX[[1]],type="l", xlim=lim_temp,lwd=0.3,xlab=" ", ylab=" ",cex.main=1, col="gray50",
      #  main=paste("Sample",sep=""))
      #for (j in 2:min(k,200)){
      # lines(XX[[j]],type="l",lwd=0.3,col="gray50")
      #}
      #for (m in 1:length(breaks)){
      # lines(BBreaks[[m]],type="l",col="red",lwd=2)
      # }
      
      color<-rainbow(100,start=.7,end=.17)
      # Compute the z-value at the facet centres
      zfacet <- M2[-1, -1] + M2[-1, -ncol(M2)] + M2[-nrow(M2), -1] + M2[-nrow(M2), -ncol(M2)]
      facetcol <- cut(zfacet, 100)
      M<-M2
      
      #calculate plot limit for y-coordinate
      colmax<-rep(0,trunc(length(gridy)/10))
      for (i in 1:trunc(length(gridy)/10)){
        colmax[i]<-max(M[,10*i])
      }
      Cut<-data.frame(nr=seq(1,length(colmax),by=1),colmax=colmax)
      Cut<-subset(Cut,Cut$colmax>0)
      cutindex<-min(round(10*Cut$nr[nrow(Cut)]*1.25,0),length(gridy))
      ym<-min(gridy[10*Cut$nr[nrow(Cut)]]*1.25,1)
      #print(ym)
      
      Mp<-M[,1:cutindex]
      gridyp<-gridy[1:cutindex]
      
      persp(gridx,gridyp,Mp, xlab="x",  ylab="upper/lower frequency", zlab=expression(alpha),
            xlim=limx, main=paste("Histogram 3d",sep=""),cex.main=1,
            theta = -45, phi = 35, expand = 0.35, col=color[facetcol],
            shade = 0.25, ticktype = "detailed",border=NA)
      persp(gridx,gridyp,Mp, xlab="x",  ylab="upper/lower frequency", zlab=expression(alpha),
            xlim=limx, main=paste("Histogram 3d",sep=""),cex.main=1,
            theta = 45, phi = 35, expand = 0.35, col=color[facetcol],
            shade = 0.25, ticktype = "detailed",border=NA)
      
      image(gridx,gridyp,Mp, xlab="x",  ylab="upper/lower frequency", xlim=limx,
            col=rainbow(100,start=.7,end=.17),cex.axis=1,
            main=paste("Histogram level view","\n",
                       "(black lines denote 1-cut, white lines 0.5-cut)",sep=""),cex.main=1)
      contour(gridx,gridyp,Mp, xlab="",  ylab="", xlim=limx,lwd=c(1.5,1.5),
              levels = seq(0.5,1,by=0.5), add = TRUE, col = c("white","black"),
              lty = c(1,1), drawlabels=FALSE)
      
      dev.off()
    }
    if(pic==TRUE){
      color<-rainbow(100,start=.7,end=.17)
      # Compute the z-value at the facet centres
      zfacet <- M2[-1, -1] + M2[-1, -ncol(M2)] + M2[-nrow(M2), -1] + M2[-nrow(M2), -ncol(M2)]
      facetcol <- cut(zfacet, 100)
      M<-M2
      
      #calculate plot limit for y-coordinate
      colmax<-rep(0,trunc(length(gridy)/10))
      for (i in 1:trunc(length(gridy)/10)){
        colmax[i]<-max(M[,10*i])
      }
      Cut<-data.frame(nr=seq(1,length(colmax),by=1),colmax=colmax)
      Cut<-subset(Cut,Cut$colmax>0)
      cutindex<-min(round(10*Cut$nr[nrow(Cut)]*1.25,0),length(gridy))
      ym<-min(gridy[10*Cut$nr[nrow(Cut)]]*1.25,1)
      #print(ym)
      
      Mp<-M[,1:cutindex]
      gridyp<-gridy[1:cutindex]
      
      persp(gridx,gridyp,Mp, xlab="x",  ylab="upper/lower frequency", zlab=expression(alpha),
            xlim=limx, main=paste("Histogram 3d",sep=""),cex.main=1,
            theta = -45, phi = 35, expand = 0.35, col=color[facetcol],
            shade = 0.25, ticktype = "detailed",border=NA)
      dev.new()  
      image(gridx,gridyp,Mp, xlab="x",  ylab="upper/lower frequency", xlim=limx,
            col=rainbow(100,start=.7,end=.17),cex.axis=1,
            main=paste("Histogram level view","\n",
                       "(black lines denote 1-cut, white lines 0.5-cut)",sep=""),cex.main=1)
      contour(gridx,gridyp,Mp, xlab="",  ylab="", xlim=limx,lwd=c(1.5,1.5),
              levels = seq(0.5,1,by=0.5), add = TRUE, col = c("white","black"),
              lty = c(1,1), drawlabels=FALSE)
      
    }
    H<-list(gridx=gridx,gridy=gridy,M=M,breaks=breaks)
    invisible(H)
  }

DSfrequency <-
  function(XX,IV=c(0,1),pic=1,nl=101){
    #XX fuzzy sample (list)
    #IV is the interval for which the (levelwise) frequency will be calculated
    #interpretation: levelwise Dempster-Shafer frequencies
    #nl is the number of levels for which the levelwise Dempster-Shafer frequencies are calculated
    #by default nl=101
    k<-length(XX)
    temp<-rep(0,k)
    for (i in 1:k){
      temp[i]<-checking2(XX[[i]],0)
    }
    if(min(temp)==0){
      print("One or more elements of the input data defines no polygonal fuzzy number")
    }
    if(min(temp)==1){
      X<-translator(XX[[1]],nl)
      YY<-vector("list",length=k)
      YY[[1]]<-X
      
      hitting<-rep(0,nl)
      contained<-rep(0,nl)
      if(X$x[1]<=IV[2]&X$x[2*nl]>=IV[1]){
        hitting<-ifelse(X$x[1:nl]>IV[2]|X$x[(2*nl):(nl+1)]<IV[1],0,1)
        contained<-ifelse(X$x[1:nl]>=IV[1]&X$x[(2*nl):(nl+1)]<IV[2],1,0)
      }
      if(k==1){
        f<-data.frame(x=c(contained,hitting),alpha=X$alpha)
        if(pic==1){
          plot(YY[[1]],type="l", lwd=0.1,xlab="x", ylab=expression(alpha),cex.main=1, col="gray50",
               main=paste("Sample and chosen interval",sep=""))
          Left<-data.frame(x=rep(IV[1],2),alpha=c(-0.05,1.05))
          Right<-data.frame(x=rep(IV[2],2),alpha=c(-0.05,1.05))
          lines(Left,type="l",col="red",lwd=2)
          lines(Right,type="l",col="red",lwd=2)
          
          dev.new()
          plot(f,type="l",xlim=c(0,1),ylim=c(0,1),
               main=paste("Levelwise Dempster Shafer frequency of the interval [",IV[1], ",",IV[2],"]",sep=""),
               cex.main=1,xlab="x", ylab=expression(alpha))
          lines(f,type="p",cex=0.2)
        }
        invisible(f)
      }
      if(k>1){
        for (i in 2:k){
          X<-translator(XX[[i]],nl)
          YY[[i]]<-X
          hitting_dazu<-rep(0,nl)
          contained_dazu<-rep(0,nl)
          if(X$x[1]<=IV[2]&X$x[2*nl]>=IV[1]){
            hitting_dazu<-ifelse(X$x[1:nl]>IV[2]|X$x[(2*nl):(nl+1)]<IV[1],0,1)
            contained_dazu<-ifelse(X$x[1:nl]>=IV[1]&X$x[(2*nl):(nl+1)]<IV[2],1,0)
          }
          hitting<-hitting+hitting_dazu
          contained<-contained+contained_dazu
        }
        hitting<-1/k*hitting
        contained<-1/k*contained
        f<-data.frame(x=c(contained,hitting[nl:1]),alpha=YY[[1]]$alpha)
        if(pic==1){
          lower<-rep(0,k)
          upper<-lower
          for (j in 1:k){
            lower[j]<-min(YY[[j]])
            upper[j]<-max(YY[[j]])
          }
          limx<-c(min(lower),max(upper))
          plot(YY[[1]],type="l", xlim=limx,lwd=0.1,xlab="x", ylab=expression(alpha),cex.main=1, col="gray50",
               main=paste("Sample and chosen interval",sep=""))
          for (j in 2:k){
            lines(YY[[j]],type="l",lwd=0.1,col="gray50")
          }
          Left<-data.frame(x=rep(IV[1],2),alpha=c(-0.05,1.05))
          Right<-data.frame(x=rep(IV[2],2),alpha=c(-0.05,1.05))
          lines(Left,type="l",col="red",lwd=2)
          lines(Right,type="l",col="red",lwd=2)
          dev.new()
          plot(f,type="l",xlim=c(0,1),ylim=c(0,1),
               main=paste("Levelwise Dempster Shafer frequency of the interval [",IV[1], ",",IV[2],"]",sep=""),
               cex.main=1,xlab="x", ylab=expression(alpha))
          lines(f,type="p",cex=0.2)      }
        invisible(f)
      }
    }
  }


Bcov <-
  function(XX,YY,theta=1/3){
    #calculates the empirical covariance of two lists of polygonal fuzzy numbers with same levels
    #if necessary just use translator first to assure same alpha levels
    #theta ... is weight in the def of the bertoluzza metric
    kx<-length(XX)
    ky<-length(YY)
    if(kx!=ky){
      print("lists have to have same length (i.e. same sample sizes)")
    }
    #------------ calculate integrals by hand as sums -----------------
    int_product<-function(x,y){
      #x,y vector (first column of fuzzy set)
      #calculate integral of the product of x and y (equidistant alpha levels assumed)
      #product of x and y is piecewise quadratic function - integrate via simpson rule
      if(length(x)!=length(y)){return(print("input vectors must have same length"))}
      if(length(x)==length(y)){
        k<-length(x)-1
        delta<-1/k
        pr<-x*y
        middle<-(x[1:k]+x[2:(k+1)])*(y[1:k]+y[2:(k+1)])
        values<-pr[1:k]+pr[2:(k+1)]+middle
        integral<-sum(values)*delta/6
        invisible(integral)
      }
    }
    #----------------------------------------------------------
    #if all ok continue:
    if(kx==ky){
      ZZ<-vector("list",length=(2*kx))
      ZZ[1:kx]<-XX[1:kx]
      ZZ[(kx+1):(2*kx)]<-YY[1:kx]
      
      temp_sum<-Msum(ZZ)
      if(nrow(temp_sum)>1){
        k<-length(XX)
        EX<-Mmean(XX)
        EY<-Mmean(YY)
        nl<-nrow(XX[[1]])/2
        
        midEX<-0.5*(EX$x[1:nl]+EX$x[(2*nl):(nl+1)])
        sprEX<-0.5*(EX$x[1:nl]-EX$x[(2*nl):(nl+1)])
        midEY<-0.5*(EY$x[1:nl]+EY$x[(2*nl):(nl+1)])
        sprEY<-0.5*(EY$x[1:nl]-EY$x[(2*nl):(nl+1)])
        contr_Emids<-int_product(midEX,midEY)
        contr_Espreads<-int_product(sprEX,sprEY)
        
        contr_mids<-rep(0,k)
        contr_spreads<-rep(0,k)
        
        for(i in 1:k){
          z<-XX[[i]]$x
          w<-YY[[i]]$x
          midX<-0.5*(z[1:nl]+z[(2*nl):(nl+1)])
          sprX<-0.5*(z[1:nl]-z[(2*nl):(nl+1)])
          midY<-0.5*(w[1:nl]+w[(2*nl):(nl+1)])
          sprY<-0.5*(w[1:nl]-w[(2*nl):(nl+1)])
          
          contr_mids[i]<-int_product(midX,midY)/k
          contr_spreads[i]<-int_product(sprX,sprY)/k
        }
        
        cova<-(sum(contr_mids)-contr_Emids + theta*(sum(contr_spreads)-contr_Espreads))
        invisible(cova)
      }
    }
  }


flr1 = function(xpar,X,m,l,r,J){
  beta_m = xpar[1:(J+1)]; beta_l = xpar[J+2]; beta_r = xpar[J+3]
  mStar = X%*%beta_m; lStar = mStar*beta_l; rStar = mStar*beta_r;
  return(norm(m-mStar,type="2")^2 + norm(l-lStar,type="2")^2 + norm(r-rStar,type="2")^2)
}

r2 = function(m,l,r,mStar,lStar,rStar){
  #r2=ESS/TSS
  #ESS: explained sum of squares
  #TSS: total sum of squares
  return( (norm(mStar-mean(m),type="2")^2 / norm(m-mean(m),type="2")^2  + 
             norm(lStar-mean(l),type="2")^2 / norm(l-mean(l),type="2")^2 + 
             norm(rStar-mean(r),type="2")^2) / norm(r-mean(r),type="2")^2) 
}

rss = function(m,l,r,mStar,lStar,rStar){
  #RSS:residual sum of squares
  return( (norm(mStar-m,type="2")^2 + norm(lStar-l,type="2")^2 +norm(rStar-r,type="2")^2))
}


flr1_predict = function(X,beta){
  J=NCOL(X)-1
  beta_m = beta[1:(J+1)]; beta_l = beta[J+2]; beta_r = beta[J+3]
  mStar = X%*%beta_m; lStar = mStar*beta_l; rStar = mStar*beta_r;
  Ypred = cbind(mStar,lStar,rStar); colnames(Ypred) = c("m","l","r")
  return(Ypred)
}
