#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2020/2021
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ##################################
# (A) Intro generale ai metodi Monte Carlo
# (B) Statistiche e metodi Monte Carlo
##########################################################

# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/") #to be changed based on your own working directory!
set.seed(1234) #fissiamo il seme per il generatore di numeri casuali


# (A) Intro generale ai metodi Monte Carlo -----------------------------------------
# MC methods are a broad class of computational algorithms that rely on repeated random sampling to obtain numerical results
# ulteriori dettagli su: https://en.wikipedia.org/wiki/Monte_Carlo_method

# Supponiamo X ~ N(mu=100,sigma=25) e vogliamo calcolare P(X > 75)
x = seq(from=20,to=180,length.out = 100)
plot(x,dnorm(x = x,mean=100,sd = 25),type="l")
abline(v=100,lty=2); abline(v=75,lty=2,col=4) # X=75
# P(X > 75) è l'area a sinistra della linea blu tratteggiata

# Calcoliamo P(X>75) usando la funzione di ripartizione F(X)
p_75 = 1-pnorm(q = 75,mean = 100,sd = 25)
print(p_75)

# Calcoliamo P(X>75) come integrale
# dnorm() implementa la densità normale: 1/(sigma*sqrt(2*pi)) * exp(-0.5*((x-mu)^2/sigma)^2)
fx = function(x)dnorm(x,100,25) # funzione di densità di X, ossia f(X)
p_75_int = integrate(f = fx,lower = 75,upper = Inf)
print(p_75_int$value)

# Un metodo alternativo per calcolare P(X>75) è quello di ricorrere ai metodi Monte Carlo dove l'area di f(x) 
# corrispondente all'intervallo [75,+Inf) è ottenuta via simulazione

# generiamo numeri casuali secondo il modello X~N(mu=100,sigma=25) poiché conosciamo F(X) in questo caso
xsim = rnorm(n = 50, mean = 100, sd = 25)
simdata = data.frame(values=xsim, acceptance = xsim >= 75) # acceptance contiene i valori simulati maggiori o uguali al quantile desiderato    
head(simdata)

# Definizione dei colori rappresentazione grafica dei valori simulati a seconda che siano maggiori ("black") o minori ("red") di 75
xcolors = rep(NA,length(simdata$values))
xcolors[simdata$values>=75] = "black"
xcolors[simdata$values<75] = "red"

plot(x,dnorm(x = x,mean=100,sd = 25),type="l") # Grafico curva normale
abline(v=100,lty=2); abline(v=75,lty=2,col=4)  # Linea della media (nero) e valore 75 (blu)
points(x = simdata$values, y = rep(0.01,length(simdata$values)), pch=4, cex=1, col=xcolors) # Valori simulati

p_75_mc = sum(simdata$acceptance)/nrow(simdata) # sfruttiamo il fatto che l'integrale è approssimabile da somme discrete
print(p_75_mc)  #risultato leggermente diverso da quello atteso 

## Riscriviamo l'esempio precedente all'interno di una funzione parametrizzata 
mc_simulation = function(n, val=75, mean=100, sd=25){
  xsim = rnorm(n = n, mean = mean, sd = sd)
  sim = data.frame(values=xsim, acceptance = xsim >= val)   
  
  xcolors[simdata$values>=75] = "black"
  xcolors[simdata$values<75] = "red"
  
  p_mc = sum(sim$acceptance)/nrow(sim)  # Percentuale dei valori maggiori di 75
  return(p_mc)
}


## Utilizzando la funzione creata precedentemente, analizziamo l'approssimazione Monte Carlo all'integrale normale 
## facendo variare n (numero di estrazioni dalla densità di riferimento)
mc_simulation(n = 25,val = 75,mean = 100,sd = 25)
mc_simulation(n = 100,val = 75,mean = 100,sd = 25)
mc_simulation(n = 500,val = 75,mean = 100,sd = 25)
mc_simulation(n = 1000,val = 75,mean = 100,sd = 25)
mc_simulation(n = 10000,val = 75,mean = 100,sd = 25)
mc_simulation(n = 100000,val = 75,mean = 100,sd = 25)
# notiamo come l'approssimazione migliora, si avvicina al valore esatto dell'integrale "p_75", all'aumentare del numero di simulazioni


## Facciamo un altro esempio dell'uso dei metodi MC per la risoluzione di integrali definiti
fx = function(x){exp(x)*sin(pi)+(1/sqrt(abs(sin(x))))} # ..una funzione a salti
x = seq(from=0.1,to=10,length.out = 100) # dominio reale dove valutare fx
plot(x,fx(x),type="l") # grafico di fx

# Calcoliamo l'integrale (per via numerica) di fx nell'intervallo [2,4]
plot(x,fx(x),type="l"); abline(v = c(2,4),col=2,lty=2)
fx_int = integrate(f = fx,lower = 2,upper = 4)
print(fx_int$value)

# Approssimiamo ora l'integrale via MC
a=2; b=4
y = runif(n = 10000,min = a,max = b) # generiamo tante osservazioni dalla legge X~Unif(a=0.1,b=10) nell'intervallo di integrazione di fx
fx_mc = (b-a)*mean(fx(y)) # usiamo la formula generale dell'integrazione MC
print(c(fx_mc,fx_int$value)) # valore dell'integrale numerico vs. valore simulato


# (B) Statistiche e metodi Monte Carlo ------------------------------------

## ESEMPIO 1 #############################################################################
# Altezza massima delle piante - fonte: P(12.7)
# Un agricoltore deve comprare n=50 paletti per sostenere le sue viti. Deve valutare quale altezza di paletti scegliere, in relazione questa 
# all'altezza futura X delle piante (altezza in cm che egli ritiene le piante raggiungeranno). Sulla base di dati storici, formalizza la sua esperienza secondo la
# legge X ~ N(mu=120,sigma=10). L'agricoltore fa uno studio di simulazione in cui valuta M scenari possibili di crescita delle viti.
# Formalmente, ciò che l'agricoltore deve sapere per comprare i paletti è la v.a. X_max = max(X_1,...,X_50). 

M=5000 # numero di scenari
x_max = rep(NA,M) # array per immagazzinare i dati
for(j in 1:M){
  print(paste("Simulazione no.:",j,sep=" "))
  x = rnorm(n = 50,mean = 120,sd = 10)
  x_max[j] = max(x)  
}
summary(x_max) # statistiche descrittive dei campioni x_max
par(mfrow=c(1,2))
hist(x_max,breaks = 30,xlab="",ylab="",main="max(X1,...,Xn)")
abline(v=mean(x_max),lty=2,col=2);abline(v=median(x_max),lty=2,col=3);abline(v=quantile(x_max,probs = c(0.05,0.95)),lty=2,col=4); #aggiungiamo media, mediana, quantili
plot(density(x_max),bty="n",main="stima di f(X_max)",xlab="") # istogramma perequato (stima della densità tramite metodi di kernel smoothing)

############################################################################################

