#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2020/2021
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ################################
# (A) Model checking: caso Normale
# (B) Model checking: caso Poisson
########################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/") #to be changed based on your own working directory!

# Una volta che un modello statistico F(y;theta) è adattato ad un campione di dati y={y1,..,yn} è possibile valutare la bontà del modello rispetto alla:
# 1. capacità di riprodurre i dati y (o alcune statistiche dei dati, es.: media)
# 2. valutarecapacità predittiva del modello adattato su nuovi campioni di dati y'
# 3. capacità predittiva usando tecniche di validazione incrociata se n è molto grande (cross-validation)
# 4. capacità predittiva usando approcci Monte Carlo per generare nuovi campioni di dati y',y'',.. e capire cosa il modello F(y;theta) è capace di replicare o meno del fenomeno che si vuole analizzare
# In questo laboratorio affronteremo il caso 4 nel caso di un modello lineare Normale (lm) ed un modello lineare Poisson (glm)


# (A) - Model checking: caso Normale --------------------------------------
# Usando un approccio deduttivo, fissiamo il modello statistico e generiamo da esso un'istanza campionaria che utilizzeremo come campione di dati osservato (vedi modulo A, slide 37-41)
# M = {N(y;m,s), (m,s) in R x R+, y in (-inf,+inf)^n}
# m = alpha + z*beta
# (alpha,beta) in R x R
# z in {0,1}^n variabile dicotomica dove z=0 indica che l'osservazione corrispondente y appartiene al gruppo sperimentale E 
# mentre z=1 indica che y appartiene al gruppo di controllo C

set.seed(191020) #fissiamo il seme per il generatore di numeri casuali
n=250 #numerosità delle osservazioni
alpha=1; beta=-0.23; s=0.25 #fissiamo i parametri (noti) del modello
z = rbinom(n = n,size = 1,prob = 0.5) #generiamo la variabile sperimentale da una Binomiale(1,0.5)
m = alpha+z*beta #vettore delle medie m riparametrizzate mediante un modello lineare
y = rnorm(n,m,s) #estraiamo un campione di dati y di dimensione n avente media m e scarto quad medio s

boxplot(y[z==0],y[z==1],names = c("E","C")) #rappresentiamo graficamente i dati campionati y rispetto alla variabile sperimentale z

# Adattiamo un modello lineare tipo Normale ai dati. Nota: conosciamo F(y;theta) in questo caso.
mod1 = lm(formula = y~z) #adattiamo un modello lineare
summary(mod1)
alpha_est = summary(mod1)$coefficients[1,1]
beta_est = summary(mod1)$coefficients[2,1] #estraiamone i coeffs alpha e beta
s_est = summary(mod1)$sigma #estraiamo sigma

# Dopo aver adattato il modello N(y;m,s) ai dati campionari y, valutiamo la capacità predittiva del modello usando un approccio Monte Carlo per generare
# M istanze che verranno poi comparate con i dati osservati y usando alcune statistiche t(y) dei dati osservati e t(y'_1,..,y'_M) dei dati simulati.
M = 1000 # fissiamo il numero di campioni da generate
Ypred = matrix(NA,nrow = M,ncol = n) #array che conterrà le istanze generate: ciascuna riga è un campione/istanza di dimensione n
m_pred = alpha_est+z*beta_est #calcoliamo il predittore lineare del modello
for(m in 1:M){
  print(paste("Prediction no.:",m,sep=" "))
  Ypred[m,] = rnorm(n,m_pred,s_est)
}
print(Ypred[1:5,1:10])

y_density = density(y) #stimiamo e rappresentiamo la densità F(y;theta) delle osservazioni y
plot(y_density$x,y_density$y,type="l",bty="n",main="Estimated density plot of y",xlab="",ylim=c(0,max(y_density$y)+0.35),ylab="")

# sovrapponiamo le densità dei campioni simulati ed aggiungiamo alla fine la densità di y osservato
for(m in 1:M){lines(density(Ypred[m,]),col="gray")}
lines(y_density$x,y_density$y,lwd=2.5)

# Per confrontare i dati campionari y rispetto a quelli predetti dal modello {y'_1,...,y'_M} possiamo usare una statistica di sintesi t(y) dei dati osservati
# t: Y^n -> R
# e confrontarla con i dati generati/predetti dal modello adattato. Il razionale è quello di valutare dove si situa y(t) rispetto alla distribuzione predetta F(t(y'_1,..,y'_M)):
# se la distribuzione predittiva contiene t(y) con alta probabilità allora i dati simulati {y'_1,..,y'_M} sono plausibili con quelli osservati y. 
# In questo caso il modello è adeguato rispetto a y, ossia le istanze generate da F(y;theta) sono compatibili con quanto osservato nella realtà (mediante y).

# Prima statistica: media e varianza
yt_pred = apply(Ypred,1,mean) #calcoliamo la media row-wise, ottenendo un vettore finale Mx1
yt_obs = mean(y) #media dei dati osservati
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2) #grafico di entrambe le quantità
# per calcolare una misura di concordanza delta_t tra t(y) e t(y'_1,..,y'_M) possiamo utilizzare la seguente:
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)
# valori prossimi allo zero per delta_t indicano che il modello non è adeguato nel riprodurre la caratteristica t(y) dei dati 
# e modifiche opportune devono essere effettuate se si vuole che tali caratteristiche siano riprodotte (es.: riparametrizzare theta, cambiare F).

yt_pred = apply(Ypred,1,var) #calcoliamo la media row-wise, ottenendo un vettore finale Mx1
yt_obs = var(y) #media dei dati osservati
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2) #grafico di entrambe le quantità
# per calcolare una misura di concordanza delta_t tra t(y) e t(y'_1,..,y'_M) possiamo utilizzare la seguente:
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)


# Seconda statistica: minimo
yt_pred = apply(Ypred,1,min)
yt_obs = min(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

# Terza statistica: massimo
yt_pred = apply(Ypred,1,max)
yt_obs = max(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

# Quarta statistica: simmetria
yt_pred = apply(Ypred,1,function(x)psych::skew(x)) #utilizziamo la funzione skew() presente nella libreria psych
yt_obs = psych::skew(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)
# i dati osservati hanno indice di asimmetria positivo (yt_obs>0) e ciò indica che la distribuzione dei dati osservati presenta massa maggiore verso la sinistra 
# rispetto invece ai dati simulati. Ciò indica che il modello non è in grado di cogliere bene questa caratteristica dei dati.
# Nota: occorre capire sempre se la caratteristica in oggetto valutata mediante t(y) rappresenti una caratteristica desiderata del fenomeno che si sta
# studiando oppure una qualità non desiderata e contingente, la cui presenza è dovuta a limiti della metodologia campionaria (es.: n piccolo).

# Quinta statistica: kurtosi
yt_pred = apply(Ypred,1,function(x)psych::kurtosi(x)) #utilizziamo la funzione kurtosi() presente nella libreria psych
yt_obs = psych::kurtosi(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)
# i dati osservati presentano un indice di kurtosi negativo e ciò sta ad indicare che la distribuzione associata è di tipo platicurtica. Il modello 
# sembra generare istanze che riescano a cogliere questa caratteristica, come si evince dal valore della misura delta_t

# In definitiva, possiamo concludere che il modello lineare adattato N(y;m,s) con m = alpha+z*beta riproduca in generale istanze compatibili con quanto osservato (si veda il grafico delle densità sovrapposte).
# In particolare, rispetto alle caratteristiche di posizione (media), dispersione (varianza), quantili (minimo, massimo) il modello è compatibile con quanto osservato.
# Allo stesso modo, considerando la forma della distribuzione del fenomeno indagato, il modello è compatibile rispetto alla kurtosi e lo è meno rispetto alla simmetria.
# In quest'ultimo caso occorre chiederci se la presenza di asimmetria negativa osservata nei dati y sia una caratteristica peculiare del fenomeno indagato
# o se invece non sia frutto del disegno campionario. In quest'ultimo caso, potrebbe essere opportuno rifare la rilevazione con un campione diverso e più ampio.


# (B) - Model checking: caso Poisson --------------------------------------
# In questo secondo scenario, consideriamo il caso di un modello lineare tipo Poisson utilizzato per modellare, tra le altre cose, variabili tipo conteggio.
# Esempi di applicazione di variabili conteggio sono innumerevoli nelle ricerche psicologiche (es.: numero di errori ad un test cognitivo).
# Per mantenere la medesima struttura logica della sezione precedente, consideriamo una variabile risposta y tipo conteggio, ossia y in (0,1,2,..), 
# ed una variabile manipolata z in {0,1}, dove z=0 indica l'appartenenza dell'osservazione y al gruppo sperimentale (E) mentre z=1 indica l'appartenenz al gruppo di controllo (C).
# Il modello è definito come segue:
# M = {Poi(y;m), m in R+, y in (0,1,2,...)^n}
# m = exp(alpha+z*beta) *predittore lineare
# (alpha,beta) in R x R
# z in {0,1}^n variabile dicotomica dove z=0 indica gruppo sperimentale E mentre z=1 indica gruppo di controllo C

set.seed(191020) #fissiamo il seme per il generatore di numeri casuali
n=250 #numerosità delle osservazioni
alpha=0; beta=1.11 #fissiamo i parametri (noti) del modello
z = rbinom(n = n,size = 1,prob = 0.5) #generiamo la variabile sperimentale da una Binomiale(1,0.5)
m = alpha+z*beta #vettore delle medie m riparametrizzate mediante un modello lineare
y = rpois(n,exp(m)) #estraiamo un campione di dati y di dimensione n avente media e varianza m (vedi modulo A, slide 35)

boxplot(y[z==0],y[z==1],names = c("E","C")) #rappresentiamo graficamente i dati campionati y rispetto alla variabile sperimentale z
head(cbind(y,z),n=10) # alcuni dati osservati {(y1,z1),..,(yn,zn)}

# Un modo frequente ma errato di analizzare dati tipo conteggio è mediante l'utilizzo di un modello lineare tipo Normale, in cui si assume che la variabile
# risposta provenga dunque da un modello normale avente media decomposta secondo il predittore lineare m = alpha+z*beta, dove z è solitamente una variabile 
# manipolata sperimentalmente. Ad esempio, in un compito cognitivo dove y è il numero di errori mentre z rappresenta l'appartenenza al gruppo sperimentale (ovvero controllo),
# i dati spesso vegnono analizzati mediante un modello Anova (Analysis Of Variance) che assume che y sia distribuita normalmente. 
# Seguiamo la stessa logica d'analisi, utilizzando un modello Normale in luogo di quello noto (vale a dire Poisson). 
# Questo è un tipico esempio di misspecified model.

mod1 = lm(formula = y~z) #adattiamo un modello lineare
summary(mod1)
alpha_est = summary(mod1)$coefficients[1,1]
beta_est = summary(mod1)$coefficients[2,1] #estraiamone i coeffs alpha e beta
s_est = summary(mod1)$sigma #estraiamo sigma


# Come nel caso precedente, usiamo un metodo Monte Carlo per generare istanze dal modello ipotizzato
M = 1000 # fissiamo il numero di campioni da generate
Ypred = matrix(NA,nrow = M,ncol = n) #array che conterrà le istanze generate: ciascuna riga è un campione/istanza di dimensione n
m_pred = alpha_est+z*beta_est #calcoliamo il predittore lineare del modello
for(m in 1:M){
  print(paste("Prediction no.:",m,sep=" "))
  Ypred[m,] = rnorm(n,m_pred,s_est)
}
print(Ypred[1:5,1:10])

# Come nel caso precedente, rappresentiamo graficamente la distribuzione dei dati osservati e quelle dei dati simulati
suppy = min(y):max(y) #supporto della variabile risposta (in questo caso, nota, è discreta)
py = table(y)/n #frequenze relative associate agli elementi del supporto
plot(x=suppy,y=py,bty="n",xlim=c(-2,max(suppy)+2.5),ylab="freqs",xlab="y",col=10,lwd=2.5);
segments(x0=suppy,x1=suppy,y0=0,y1=py,lwd=1.5) #serve solo per aggiungere i segmenti verticali a ciascun punto massa di probabilità
for(m in 1:M){lines(density(Ypred[m,]),col="gray")}
points(x=suppy,y=py,col=10,lwd=2.5);segments(x0=suppy,x1=suppy,y0=0,y1=py,lwd=1.5)
# notiamo subito come le distribuzioni dei dati generati sconfinano oltre l'estremo inferiore del supporto della variabile y:
# vale a dire, il modello lineare Normale predice dati al di fuori del range naturale della variabile Y (abbiamo difatti conteggi negativi).

# Prima statistica: media e varianza
yt_pred = apply(Ypred,1,mean) #calcoliamo la media row-wise, ottenendo un vettore finale Mx1
yt_obs = mean(y) #media dei dati osservati
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2) #grafico di entrambe le quantità
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

yt_pred = apply(Ypred,1,var) #calcoliamo la media row-wise, ottenendo un vettore finale Mx1
yt_obs = var(y) #media dei dati osservati
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2) #grafico di entrambe le quantità
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

# Seconda statistica: minimo
yt_pred = apply(Ypred,1,min)
yt_obs = min(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

# Terza statistica: massimo
yt_pred = apply(Ypred,1,max)
yt_obs = max(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

# Quarta statistica: simmetria
yt_pred = apply(Ypred,1,function(x)psych::skew(x)) #utilizziamo la funzione skew() presente nella libreria psych
yt_obs = psych::skew(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)

# Quinta statistica: kurtosi
yt_pred = apply(Ypred,1,function(x)psych::kurtosi(x)) #utilizziamo la funzione kurtosi() presente nella libreria psych
yt_obs = psych::kurtosi(y)
hist(yt_pred,main=""); abline(v = yt_obs,col=2,lwd=2,lty=2)
delta_t = min(sum(yt_pred >= yt_obs)/M, sum(yt_pred < yt_obs)/M)
print(delta_t)


# In definitiva, il modello lineare Normale adattato a dati tipo conteggio sebbene colga parte della tendenza centrale e della dispersione della distribuzione dei dati osservati,
# fallisce nel rappresentare i quantili massimo/minimo della variabile conteggio e nel catturare la forma della distribuzione dei dati (simmetria/kurtosi).
# In questo caso, se utilizzato, il modello Normale predirrebbe valori inammissibili (conteggi negativi) in media pari a
print( mean(apply(Ypred,1,function(x)sum(x<0))) )
# In generale, il modello Normale può essere utilizzato per rappresentare dati conteggio se il conteggio medio è un numero molto grande. In tal modo, tra le altre cose, si previene il problema dei conteggi negativi.

