#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2020/2021
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ################################
# (A) Esplorazione dei dati
# (B) Stima di eta e della precisione
########################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/") #to be changed based on your own working directory!
set.seed(1234) #fissiamo il seme per il generatore di numeri casuali

# (A) Esplorazione dei dati ---------------------------------------------------

## caricamento dei dati
load("laboratorio/data/data_lab3.rda")
str(datax)
summary(datax)
n = dim(datax)[1]; t = dim(datax)[2]

## istogramma delle misurazioni
par(mfrow=c(2,4))
for(j in 1:t){
  hist(datax[,j],xlab = "measure",main=paste("time: ",j,sep=""))
  abline(v = mean(apply(datax,2,mean)),col=2,lty=3,lwd=2) #media complessiva
}

## istogramma è un modello parametrico ed il parametro è il numero di bin/breaks: al variare del parametro cambia il risultato ottenuto
par(mfrow=c(2,2))
hist(datax[,1],breaks = 10)
hist(datax[,1],breaks = 25)
hist(datax[,1],breaks = 75)
hist(datax[,1],breaks = 150)

## Tre modi per calcolare il numero di bin/breaks
par(mfrow=c(1,3))
hist(datax[,1],breaks = 1+log2(n),main="Bins con Sturges")
hist(datax[,1],breaks = 2*n^(1/3),main="Bins con Rice")
hist(datax[,1],breaks = sqrt(n),main="Bins con Radice quadrata")


# (B) Stima di eta e della precisione -----------------------------------------

## usiamo la funzione apply() per fare i calcoli colonna per colonna
datax.means = apply(datax,2,mean) #media
datax.sds = apply(datax,2,sd) #deviazione standard
datax.deltas = apply(datax,2,function(x)max(x)-min(x)) #campo di variazione
datax.cvs = apply(datax,2,function(x)sd(x)/abs(mean(x))) #coeff di variazione
datax.snrs = apply(datax,2,function(x)mean(x)/sd(x)) #rapporto segnale-rumore
datax.means.err = apply(datax,2,function(x)sd(x)/length(x)) #errore standard della media
datax.mean = mean(datax.means)

## aggreghiamo i risultati in un dataframe unico
datax.summary = cbind(datax.means,datax.sds,datax.deltas,datax.cvs,datax.snrs,datax.means.err)
colnames(datax.summary) = c("eta","sd.x","delta.x","cv.x","snr.x","sd.eta")
print(datax.summary)

## rappresentiamo medie, intervalli di incertezza, e rapporto segnale rumore
par(mfrow=c(1,1))
plot(datax.means,col=1,lwd=1,pch=16,ylim=c(2.5,22.5),xlab="time",ylab="measures") #medie
abline(h = datax.mean,col=2,lty=3,lwd=1) #media delle medie (vero valore del misurando?)
points(datax.means,col=8,lwd=sqrt(datax.snrs),pch=1) #rapporto segnale-rumore 
arrows(1:8, datax.means-datax.sds, 1:8, datax.means+datax.sds, length=0.05, angle=90, code=3) #intervalli di incertezza


