#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2020/2021
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ################################
# (A) Item dicotomici: analisi descrittive
# (B) Item dicotomici: analisi degli item
# (C) Item dicotomici: attendibilità delle scale
########################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/") #to be changed based on your own working directory!
set.seed(1234) #fissiamo il seme per il generatore di numeri casuali
library(psych)


# (A) Item dicotomici: analisi descrittive --------------------------------
datax = read.csv(file = "laboratorio/data/mobility.csv",sep = ",",header = TRUE) #the "file" parameter must be changed using your own data directory
# The dataset "datax" contains a rural subsample of 8445 women from the Bangladesh Fertility Survey of 1989. The dimension of interest is women's mobility of social freedom. 
# Women were asked whether they could engage in the following activities alone (1 = yes, 0 = no):
# Item 1: Go to any part of the village/town/city.
# Item 2: Go outside the village/town/city.
# Item 3: Talk to a man you do not know.
# Item 4: Go to a cinema/cultural show.
# Item 5: Go shopping.
# Item 6: Go to a cooperative/mothers' club/other club.
# Item 7: Attend a political meeting.
# Item 8: Go to a health centre/hospital.
# Get more info by typing ?ltm::Mobility (you need to install the R package "ltm" first)

# Prime visualizzazioni della struttura dei dati
str(datax)
head(datax)

# Statistiche descrittive e grafiche
describe(datax)

x11();par(mfrow=c(2,4))
for(j in 1:8){
  barplot(table(datax[,j]),main = colnames(datax)[j]) #distribuzioni di frequenza per ciascun item 
}

# Proporzioni di SI=1/NO=0 per ciascun item
# Usiamo la funzione apply() per il calcolo senza usare il ciclo for()
datax.prop = apply(X = datax,MARGIN = 2,FUN = table)
datax.prop = prop.table(x = datax.prop,margin = 2) #margin=2 allows columns/items to sum 1
print(datax.prop)

# Calcoliamo un indice di eterogeneità per variabili categoriali (mutabili), ad esempio 
# l'indice di entropia normalizzata Hj = -sum(fi*log(fi))/log(2). Nota: log(2) permette di normalizzare l'indice, 2 è il numero di categorie (item dicotomici)
# Usiamo la funzione apply() per il calcolo senza usare il ciclo for()
datax.H = apply(X = datax.prop,MARGIN = 2,FUN = function(x){-sum(x*log(x))/log(length(x))}) #in questo caso FUN specifica una funzione ad-hoc da noi definita, ossia la funzione di entropia: H(x) = -sum(x)*log(x)/log(length(x)) dove length(x)=2 in questo caso
print(datax.H)
# notiamo come gli item 5 e 7 presentano bassa entropia: le frequenze di risposte sono difatti concentrate su una sola delle due categorie. Nota: H(x)=1 (max entropia) quando f(x=0)=0.5 e f(x=1)=0.5 (dist uniforme sulle due categorie)

par(mfrow=c(1,1)) #ri-settiamo una sola finestra grafica
plot(x = 1:8,y = datax.H,type="b",bty="n",ylim = c(0,1));abline(h = 0.5,col=2,lty=2)



# (B) Item dicotomici: analisi degli item ---------------------------------
# Il questionario utilizzato precedentemente è composto da item di tipo dicotomico che non presentano alternativa di risposta corretta.
# Per ragioni didattiche, assumiamo che Y=1 sia la risposta corretta e continuiamo ad analizzare il dataset precedente "mobility"

# Indice di difficoltà (calcolato come proporzione di risposte corrette: item scorretti presentano basse proporzioni di Y=1)
h = 1-apply(X = datax,MARGIN = 2,FUN = function(x)sum(x==1)/length(x))
# quando h->1 l'item è più difficile
plot(x = 1:8,y = h,type = "b",ylim = c(0,1),bty="n",xlab = "item",ylab = "difficoltà")
# gli item che presentano delle criticità (in quanto più difficili) sono gli item 5,7,8
# tali item, in generale, sono anche quelli che presentano bassa eterogeneità/varianza:
apply(datax,2,var)
# difatti gli item 5,7,8 sono quelli che presentano pattern di risposta poco/per nulla variabile (in questo caso quasi tutti i valori sono Y=0)

# Capacità discriminativa
source(file = "laboratorio/utilities/idi.R") #carichiamo la funzione esterna per calcolare l'indice di Ebel
datax.df = as.data.frame(datax) # trasformiamo la matrice datax in dataframe per la funzione idi()

#..caso di applicazione ad un solo item
datax.idi = idi(data = datax.df,item = 1-datax.df[,1],perc_cut = 0.25) # nota: 1-item è dovuto al fatto che la risposta corretta è Y=1, di default è Y=0
diff(datax.idi) #calcolo dell'indice per differenza diff() tra proporzioni di quantili
# l'item presenta un indice superiore alla soglia di 0.30 (l'item dunque discrimina bene tra alti e bassi punteggi)

#..applicazione di idi() a tutti gli item
datax.disc = rep(NA,8) #per salvare i valori dell'indice
for(j in 1:8){
  datax.disc[j] = diff(idi(data = datax.df,item = 1-datax.df[,j],perc_cut = 0.25))
}
print(datax.disc)
plot(x = 1:8,y = datax.disc,type="b",bty="n")
abline(h = 0.20,lty=2,col=2)
which(datax.disc<0.20) # item che necessitano di revisioni (secondo la soglia di Ebel)

# Calcolo del coefficiente di correlazione punto-biseriale
datax.ts = apply(datax,1,sum) #calcolo del punteggio totale al test (per somma)
datax.pb = rep(NA,8) #per salvare i valori dell'indice
for(j in 1:8){
  datax.pb[j] = ltm::biserial.cor(x = datax.ts,1-datax[,j]) 
}
print(datax.pb)
barplot(names.arg = 1:8,datax.pb,bty="n",xlab="item",ylab="correlazione p-biseriale",ylim=c(0,1))



# (C) Item dicotomici: attendibilità delle scale --------------------------
source(file = "laboratorio/utilities/reliability.R") #carichiamo alcune funzioni utili
kr20(datax) # attendibilità complessiva utilizzando l'indice KR20 per item dicotomici

# Valutiamo come cambia l'indice KR20 se eliminiamo, uno alla volta, un item dal test
datax.kr20.removed = matrix(NA,nrow = 8,ncol = 2) # per salvare i risultati del ciclo for()
colnames(datax.kr20.removed) = c("KR20","item dropped") #intestazioni di colonna della matrice dei risultati
for(j in 1:8){
  datax.kr20.removed[j,1] = kr20(datax[,-j]) #calcolo del KR20 senza l'item j
  datax.kr20.removed[j,2] = j #item scartato
}
print(datax.kr20.removed)
plot(x = datax.kr20.removed[,2],y = datax.kr20.removed[,1],ylim=c(0.7,0.8),bty="n",type="b")
abline(h = kr20(datax),col=2,lty=2) #kr20 complessivo 

# L'indice KR20 è linearmente associato alla correlazione punto-biseriale
plot(datax.pb,datax.kr20.removed[,1],bty="n",xlab="correlazione pb",ylab="kr20")
# ..eliminare item con alta corr pb fa diminure l'indice kr20

# Attendibilità complessiva utilizzando la procedura Split-Half
source(file = "laboratorio/utilities/split_half.R")
split_half(data = datax,type = "alternate") # divisione per item pari e dispari (type="alternate")
split_half(data = datax,type = "random") # divisione per item casuale
# Il risultato del coeff di attendibilità calcolato mediante type="random" potrà subire fluttuazioni dipendenti dal tipo di suddivisione casuale realizzata


## Nota: un output dettagliato e unico per l'analisi descrittiva degli item e l'analisi dell'attendibilità può anche essere ottenuta 
## utilizzando le funzioni descript() o scoreItems() delle librerie, rispettivamente, ltm e psych. Ad esempio, rispetto al dataset dicotomico finora utilizzato:
datax.all1 = ltm::descript(data = datax,chi.squared = FALSE)
print(datax.all1)

datax.all2 = psych::scoreItems(keys = rep(1,8),items = datax,totals = TRUE)
print(datax.all2)
str(datax.all2)

# Ulteriori info possono essere ottenute mediante la guida delle rispettive funzioni ?descript e ?scoreItems


