#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2020/2021
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ##################################
# (A) Stima delle quantità della TCT
# (B) Stime della TCT e coerenza interna degli items
# (C) Aggiungere items ad una scala
# (D) Utilizzo delle quantità stimate tau
##########################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/")


#  (A) Stima delle quantità della TCT -------------------------------------

## Esempio con dati simulati
# Costruiamo un insieme di misure parallele (aventi media e varianza uguale) che definiscono un certo
# misurando (o costrutto latente). Per costruzione, ogni item (misura parallela) sarà campionata dalla
# medesima legge di probabilità x ~ N(mu=mu0, sigma=sqrt(sigma0)). 

# Per generare un modello TCT a misure parallele usiamo la funzione sim.congeneric() della libreria psych.
# La funzione permette di generare test che abbiano misure secondo le assunzioni (p1)-(p4) affrontate nelle slide 29-45, modulo B.
# In particolare, la funzione utilizza due input per generare i dati, "loads" e "err", e sono utilizzati come di seguito:
# (p1) misure parallele: "loads" uguali, "err" uguali
# (p2)-(p3) misure tau-equivalenti: "loads" uguali, "err" differenti
# (p4) misure congeneriche: "loads" differenti, "err" differenti
# More info: ?sim.congeneric

set.seed(12341)
n=25 #numero di individui (unità statistiche)
p=4 #numero di misure parallele
D=psych::sim.congeneric(loads = rep(0.2,p),N = n,short=FALSE)
X = D$observed
head(X)
summary(X)

# Stima di VAR[E]
VAR.E = var(apply(X,1,sum))*(1-coef_alpha(X))

# Stima di VAR[T]
VAR.T = var(apply(X,1,sum))*(coef_alpha(X))

## stima dell'attendibilità
rho2_yt = VAR.T/(VAR.T+VAR.E) #uguale a: coef_alpha(X)

## stima del punteggio vero E(T) 
x = apply(X,1,sum)
mu.x = mean(x)
E.T = rho2_yt*x + (1-rho2_yt)*mu.x

x11()
plot(x,bty="n",ylab="punteggi medi osservati",xlab="soggetti",cex=3,ylim=c(min(x)-1,max(x)+1))
points(E.T,col=2,pch=2,cex=3); abline(h = mu.x,lty=2,col=1)
legend("topright",legend = c("osservati","veri"),col = c(1,2),pch=c(1,2),bty = "n")

# Notiamo come i punteggi veri per gli n soggetti sono molto simili tra loro e presentano poca fluttuazione rispetto ai valori osservati. Ciò è dovuto alla bassa
# precisione (rho2_yt) del test nel misurare la quantità di interesse. Inoltre notiamo anche come VAR.E > VAR.T
# Difatti, la correlazione tra le misure parallele è (per come abbiamo costruito gli indicatori x) piuttosto bassa:
D$r

# Proviamo ad aumentare la correlazione tra gli item, cioè tra le variabili osservate. Per far ciò, generiamo le osservate come in precedenza, aumentando questa volta il parametro "loads"
D=psych::sim.congeneric(loads = rep(0.8,p),N = n,short=FALSE) 
X = D$observed

# Procediamo ora a stimare le quantità di interesse della TCT
# Stima di VAR[E]
VAR.E = var(apply(X,1,sum))*(1-coef_alpha(X))

# Stima di VAR[T]
VAR.T = var(apply(X,1,sum))*(coef_alpha(X))

## stima dell'attendibilità
rho2_yt = VAR.T/(VAR.T+VAR.E) #uguale a: coef_alpha(X)

## stima del punteggio vero E(T) 
x = apply(X,1,sum)
mu.x = mean(x)
E.T = rho2_yt*x + (1-rho2_yt)*mu.x

x11()
plot(x,bty="n",ylab="punteggi medi osservati",xlab="soggetti",cex=3,ylim=c(min(x)-1,max(x)+1))
points(E.T,col=2,pch=2,cex=3); abline(h = mu.x,lty=2,col=1)
legend("topright",legend = c("osservati","veri"),col = c(1,2),pch=c(1,2),bty = "n")

# A differenza dei dati precedenti, possiamo notare come in questo caso VAR[T] > VAR[E] unitamente al fatto che la precisione del test rho2_yt è abbastanza alta.
# Conseguentemente, i punteggi stimati tau presentano una maggiore fluttuazione intorno alla loro media. 


# (B) Stime della TCT e coerenza interna degli items ---------------------
# Abbiamo dunque compreso come la stima delle quantità della TCT sono in stretta relazione alla 'coerenza interna' delle osservabili,
# ossia alla struttura di correlazione che intercorre tra le variabili (items).
# Effettuiamo ora un piccolo studio di simulazione per comprendere al meglio tale relazione dove facciamo variare la coerenza interna 
# degli items (da alta coerenza a coerenza nulla).

source(file = "laboratorio/utilities/sigma.R") #carichiamo alcune funzioni utili
source(file = "laboratorio/utilities/reliability.R")

n=100 #numero di individui (unità statistiche)
p=4 #numero di misure parallele

# Generiamo una matrice di covarianza da usare poi per generare le variabili X~N(mu0,Sigma0)
set.seed(123211111) #fissiamo il seme di generazione dei numeri casuali
Sigma0 = generate_Sigma0(p = p,sigmap = 3,alphad = 1e-09) #cov matrix

R = cov2cor(Sigma0) #convertiamo la matrice di covarianza in matrice di correlazione
R = R + 0.10 #usiamo la matrice di correlazione precedente aumentando ciascun elemento di 0.10
diag(R) = 1 #imponiamo che la diagonale della matrice abbia 1

# Definiamo una sequenza di valori delta per diminuire la magnitudo della correlazione fino ad azzerarla
delta = seq(from=1,to = 0.1,by = -0.1)
delta = c(delta,1e-9) #aggiungiamo un valore finale per la coerenza nulla
K = length(delta)

# Fissiamo le medie delle singole variabili
mu0=rep(100,p)

# Fissiamo la varianza delle singole variabili
sigma0=1.25

# Creiamo la matrice dei risultati che verranno popolate durante la simulazione
Y = matrix(NA,K,3)

n=1000 #numero di individui (unità statistiche)
for(k in 1:K){
  R_delta = R*delta[k] #degradiamo la correlazione
  diag(R_delta) = 1
  Sigma0 = convert_R_to_Sigma(R_delta,sigma0) #calcoliamo la matrice di covarianza
  X = mvtnorm::rmvnorm(n = n,mean = mu0,sigma = Sigma0) #generiamo i dati/misurazioni
  
  Y[k,1] = var(apply(X,1,sum))*(1-coef_alpha(X)) #VAR.E
  Y[k,2] = var(apply(X,1,sum))*(coef_alpha(X)) #VAR.T
  Y[k,3] = Y[k,2]/(Y[k,1]+Y[k,2]) #calcoliamo rho2_yt
}
colnames(Y) = c("VarE","VarT","rho2")
head(Y)
h = min(which(Y[,1]>=Y[,2]))

x11(); par(mfrow=c(1,2))
plot(delta,Y[,1],type="l",bty="n",col=2,xlab="delta",ylab="varianze")
lines(delta,Y[,2],col=4); legend("bottomright",legend = c("Var[E]","Var[T]"),col = c(2,4),bty = "n",lty=1)
abline(v = delta[h],lty=2)
plot(delta,Y[,3],type="l",bty="n",col=1,xlab="delta",ylab="attendibilità",ylim=c(0.1,0.9))
abline(v = delta[h],lty=2)

# Quando la correlazione tra le osservabili è alta (alta coerenza interna tra gli items), la precisione del test (attendibilità) è alta
# e la componente di varianza d'errore VAR[E] è inferiore a VAR[T] (ad indicare che la variabilità delle misurazioni sono da attribuire al costrutto indagato).
# Al contrario, all'aumentare del fattore di degradazione delta (e dunque al diminuire della correlazione tra gli items, al diminuire della loro coerenza interna),
# la precisione diminuisce progressivamente mentre la VAR[E] aumenta. Quando delta < 0.2 si verifica che VAR[E] > VAR[T] e ciò indica che la variabilità dei dati non
# è dovuta al costrutto indagato ma all'errore di misurazione. In questo contesto specifico, ossia quello dell'analisi della coerenza interna degli items, VAR[E] > VAR[T]
# indica che gli items utilizzati (le variabili osservate) non sono idonee a quantificare il misurando latente. L'idoneità non è da intendersi in maniera assoluta ma
# sempre rispetto al criterio della coerenza interna. Quando VAR[E] > VAR[T] diremo quindi che la scala (ossia l'insieme degli items, delle variabili osservate) usata per
# quantificare/misurare il misurando latente non è idonea rispetto al criterio della coerenza interna. 


# (C) Aggiungere items ad una scala --------------------------------------
# Prendiamo una scala contenente un certo numero di items e studiamo il problema di determinare il numero di items da aggiungere per avere una certa precisione,
# un certo livello di attendibilità. 

# Prendiamo una delle matrici di correlazione utilizzate in precedenza e generiamo delle misurazioni
set.seed(1213)
R = R*delta[5]
diag(R) = 1
Sigma0 = convert_R_to_Sigma(R,sigma0) #calcoliamo la matrice di covarianza
X = mvtnorm::rmvnorm(n = n,mean = mu0,sigma = Sigma0) #generiamo i dati/misurazioni

# Calcoliamo le quantità della TCT
VAR.E = var(apply(X,1,sum))*(1-coef_alpha(X)) #VAR.E
VAR.T = var(apply(X,1,sum))*(coef_alpha(X)) #VAR.E
rho2_yt = VAR.T/(VAR.T+VAR.E)

# Di quanto cambierebbero le varianze della misurazione se aggiungessimo m indicatori/items paralleli?
m=4 #aggiungiamo 4 items per un totale di m+p=8
VAR.T.m = VAR.T*m^2
VAR.E.m = VAR.E*m
rho2_yt.m = (m*rho2_yt)/(1+(m-1)*rho2_yt)
# L'aggiunta di m misure parallele alla scala precedente permetterebbe di aumentare considerevolmente VAR[T] così come, di conseguenza, la precisione del test rho2_yt

# Quante misure parallele m dovremmo aggiungere per portare il nostro test ad una precisione di 0.89?
# vedi BN(2.6), p.59
k = (0.89*(1-rho2_yt))/(rho2_yt*(1-0.89))
m = round(k*p) #p è il numero di item che compongono il test di base
# Per avere un test finale con attendibilità pari a 0.89 dovremmo avere un test complessivamente composto da m=16 items e, rispetto al test iniziale con p elementi, dovremmo
# aggiungerne altri (m - p) = 12.


# (D) Utilizzo delle quantità stimate tau -------------------------------
# vedi BN(2.8.0)

# Abbiamo visto nella sezione (A) come ottenere i valori veri tau = E[T] per ciascun soggetto a cui è stato somministrato un test. Ora possiamo determinare l'intervallo
# di confidenza ad un livello (1-alpha) fissato per il punteggio stesso, determinando così gli estremi di un intervallo tau_CI = [tau_lb, tau_ub] che conterranno con una probabilità
# (1-alpha) il punteggio vero del soggetto. Per le assunzioni della TCT (i)-(iii), possiamo ragionevolmente assumere che E ~ N(0,VAR[E]) e dunque utilizzare la legge normale
# per determinare gli estremi dell'intervallo tau_CI.
# Definizione: Prob[tau_i-z*sigma.e < tau_i < tau_i+z*sigma.e] = (1-alpha)
# nota: z è il quantile di riferimento (valore critico) della normale standardizzata che corrisponde al livello di probabilità alpha

alpha=0.05 #alpha è 5% 
z = qnorm(p = 1-alpha/2,mean = 0,sd = 1) #poiché la Normale è simmetrica prendiamo il quantile corrispondente a (1-alpha/2) 

# Consideriamo le misurazioni generate nella sezione precedente
set.seed(121)
iid = sample(1:NROW(X),25,replace=FALSE) #prendiamo solo 25 unità statistiche
X = X[iid,]
x = apply(X,1,mean) #punteggi totali osservati (calcolo per media e non somma)
tau = rho2_yt*x + (1-rho2_yt)*mean(x)

# Calcoliamo gli intervalli di confidenza
sigma.e = sd(x)*sqrt(1-coef_alpha(X)) #VAR.E
tau_CI = cbind(tau-z*sigma.e, tau+z*sigma.e)

# Visualizziamo tau e tau_CI
plot(tau,1:length(tau),bty="n",xlim=c(95,105),cex=1.25,pch=20,xlab="tau",ylab="soggetti")
points(tau_CI[,1],1:length(tau),col=1,pch=4)
points(tau_CI[,2],1:length(tau),col=1,pch=4)
segments(x0 = tau,x1 = tau_CI[,1],y0 = 1:length(tau),lty=2)
segments(x0 = tau,x1 = tau_CI[,2],y0 = 1:length(tau),lty=2)
abline(v = mean(x),lty=2)





