#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2020/2021
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ##################################
# (A) Indici di Person-fit non parametrici
# (B) Individuazione partecipanti anomali
##########################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/")
library(PerFit)



# (A) Indici di Person-fit non parametrici --------------------------------

# La libreria PerFit contiene diverse funzioni per il calcolo degli indici di Person-fit parametrici e non parametrici. In questo laboratorio ne vedremo
# qualcuno di quelli non parametrici.

# Carichiamo un dataset di risposte ad un test con item dicotomici
datax = read.csv(file = "laboratorio/data/mobility.csv",sep = ",",header = TRUE) #the "file" parameter must be changed using your own data directory
set.seed(1212)
iid = sample(x = 1:NROW(datax),size = 15,replace = FALSE) #selezioniamo a caso 25 partecipanti (vettore di indici)
datax = datax[iid,] 
head(datax)

# Indice G di Guttman (G-raw)
PerFit::G(matrix = datax)

# Indice G di Guttman (G-normalized)
PerFit::Gnormed(matrix = datax)

# Indici U3 e ZU3
PerFit::U3(matrix = datax)
PerFit::ZU3(matrix = datax)

# ..in alternativa
datax_pfi = PerFit::PerFit.PFS(matrix = datax,method = c("G","Gnormed","ZU3"))


# Utilizziamo un dataset di risposte ad un test con item politomici
#This data set comes from the Consumer Protection and Perceptions of Science and Technology section of the 1992 Euro-Barometer Survey (Karlheinz and Melich, 1992) 
# based on a sample from Great Britain. More info: ?ltm::Science
datax_poly = ltm::Science
head(datax_poly)
str(datax_poly)
datax_poly = sapply(X = datax_poly,FUN = as.numeric) #convertiamo ciascuna colonna (item) da variabile categoriale a numerica. Nota: sapply() funziona come il ciclo for()
datax_poly = datax_poly-1 #riscaliamo ciascun item nell'intervallo (0,3) anziché (1,4)

PerFit::Gnormed.poly(matrix = datax_poly,Ncat = 4)
PerFit::U3poly(matrix = datax_poly,Ncat = 4)


# (B) Individuazione partecipanti anomali ---------------------------------
# Per individuare profili di risposta anomali possiamo utilizzare la funzione flagged.resp() della libreria PerFit. Tale funzione, tra le altre cose, necessita
# di un vettore di valori soglia (cut-off) che permettono di individuare, rispetto al campione delle risposte, i profili individuali aberranti. 
# La libreria PerFit fornisce una funzione, cutoff(), che implementa una procedura Monte-Carlo per la generazione di tali valori soglia. 
# The procedure consists of generating Nreps response vectors based on proportion of respondents per answer category (when ModelFit="NonParametric"). 
# This allows computing a sample of Nreps values of the person fit statistic corresponding to item response patterns. A bootstrap procedure is then used 
# to approximate the sampling distribution of the quantile of person fit statistics, based on Breps resamples. The cutoff (and its standard error) is given 
# by the median (standard deviation) of this bootstrap distribution. More info: ?PerFit::cutoff

# Carichiamo il dataset completo delle risposte dicotomiche
datax = read.csv(file = "laboratorio/data/mobility.csv",sep = ",",header = TRUE) #the "file" parameter must be changed using your own data directory

# Procediamo con il calcolo dei cutoff per l'indice Gnormed
datax_gnormed = Gnormed(matrix = datax) 
str(datax_gnormed) # la funzione Gnormed() restituisce un oggetto contenente altre informazioni oltre agli indici Person-Fit
head(datax_gnormed$PFscores) # il campo PFscores contiene gli indici di Person-fit

gnormed_cutoff = cutoff(x = datax_gnormed,ModelFit = "NonParametric",Nreps = 1000,Breps = 1000)
datax_flagged = flagged.resp(x = datax_gnormed,cutoff.obj = gnormed_cutoff)
str(datax_flagged)
datax_flagged$Scores #la colonna FlaggedID contiene l'indice del partecipante che è stato identificato
dim(datax_flagged$Scores) #sono stati identificati 1381 partecipanti su 8445

# Ordiniamo i valori dell'indice di Person-fit dal più grande al più piccolo e salviamo gli indici di riga corrispondenti
iid = sort(datax_flagged$Scores[,NCOL(datax)+2],decreasing = TRUE,index.return=TRUE)$ix
datax_flagged$Scores = datax_flagged$Scores[iid,] #ri-ordiniamo la matrice dei risultati
head(datax_flagged$Scores) #la matrice è ora ordinata

X = data.frame(datax_flagged$Scores[1:25,]) #estraiamo i primi 25 partecipanti tra quelli identificati ("flaggati") con indice di PF più elevato 
print(X$FlaggedID)

# Rappresentiamo graficamente la Person-Response Function (PRF) per i partecipanti individuati come anomali
x11();par(mfrow=c(5,5))
PRFplot(datax,respID=X$FlaggedID,message = FALSE,Xlabel = "",Ylabel = "") 

# Rappresentiamo graficamente la PRF dei profili "normali"
x11();par(mfrow=c(2,3)) #rappresentiamo i profili {1,10,12,14,16,17}
PRFplot(datax,respID=c(1,10,12,14,16,17),message = FALSE,Xlabel = "",Ylabel = "") 

# Compariamo il profilo anomalo 5893 con quello normale 17
par(mfrow=c(1,2))
PRFplot(datax,respID=c(5893,17),message = FALSE,Xlabel = "",Ylabel = "") 
# Notiamo la completa inversione di tendenza tra le due curve di probabilità: il profilo segnalato come aberrante (5893) presenta una 
# probabilità di rispondere correttamente direttamente proporzionale alla difficoltà all'item (ci si aspetterebbe il contrario, ossia item 
# più difficili presentano prob di rispondere correttamente più bassa).

# Valutiamo se l'uso di due indici PF diversi conduce ad identificare gli stessi profili aberranti

# calcoliamo i due indici 
datax_poly_gnormed = PerFit::Gnormed.poly(matrix = datax_poly,Ncat = 4)
datax_poly_u3 = PerFit::U3poly(matrix = datax_poly,Ncat = 4)

# calcoliamo i cutoff via Monte-Carlo
gnormed_poly_cutoff = cutoff(x = datax_poly_gnormed,ModelFit = "NonParametric",Nreps = 1000,Breps = 1000)
u3_poly_cutoff = cutoff(x = datax_poly_u3,ModelFit = "NonParametric",Nreps = 1000,Breps = 1000)

# estraiamo i profili "flaggati" come aberranti
flagged_gnormed = flagged.resp(x = datax_poly_gnormed,cutoff.obj = gnormed_poly_cutoff)$Scores[,1]
flagged_u3 = flagged.resp(x = datax_poly_u3,cutoff.obj = u3_poly_cutoff)$Scores[,1]

# ..i profili individuati sono gli stessi?
c(length(flagged_gnormed),length(flagged_u3)) #i due indici identificano non sempre gli stessi profili (u3 ne identifica di più, ad esempio)
setdiff(flagged_u3,flagged_gnormed) #l'indice U3 individua alcuni profili in più rispetto a Gnormed (es.: 74,85,..)

# PRF di profili non individuati da Gnormed
x11();par(mfrow=c(2,4)) 
PRFplot(datax,respID=setdiff(flagged_u3,flagged_gnormed),message = FALSE,Xlabel = "",Ylabel = "") 
# notiamo come alcuni dei profili che U3 individua non sono proprio aberranti rispetto alla curva PRF (es.: profilo 74).
# L'uso degli indici di PF non parametrici deve essere utilizzato con una certa cautela.










