convert_R_to_Sigma = function(R,sigmap){
  p = NROW(R)
  if(length(sigmap)==1){sigma0 = rep(sigmap,p)}
  else{sigma0=sigmap}
  Sigma0 = diag(sigma0)%*%R%*%diag(sigma0)
  Sigma0 = as.matrix(Matrix::nearPD(x = Sigma0)$mat)
  return(Sigma0)
}

generate_Sigma0 = function(p=2,sigmap=3,alphad=1){
  R = clusterGeneration::rcorrmatrix(d = p,alphad = alphad) 
  Sigma0 = convert_R_to_Sigma(R,sigmap)
  return(Sigma0)
}
