#######################################################
### Testing psicologico (PSP6075525)
### A.A. 2021/2022
### prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################

## CONTENUTO DEL CODICE ##################################
# (A) Stima delle quantità della TCT
# (B) Stime della TCT e coerenza interna degli items
##########################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2020_2021/testing_psicologico/")
source("laboratorio/utilities/reliability.R")

#  (A) Stima delle quantità della TCT -------------------------------------

## Esempio con dati simulati
# Costruiamo un insieme di misure parallele (aventi media e varianza uguale) che definiscono un certo
# misurando (o costrutto latente). Per costruzione, ogni item (misura parallela) sarà campionata dalla
# medesima legge di probabilità x ~ N(mu=mu0, sigma=sqrt(sigma0)). 

# Per generare un modello TCT a misure parallele usiamo la funzione sim.congeneric() della libreria psych.
# La funzione permette di generare test che abbiano misure secondo le assunzioni descritte in BN(2.4).
# In particolare, la funzione utilizza due input per generare i dati, "loads" e "err", e sono utilizzati come di seguito:
# (p1) misure parallele: "loads" uguali, "err" uguali
# (p2)-(p3) misure tau-equivalenti: "loads" uguali, "err" differenti
# (p4) misure congeneriche: "loads" differenti, "err" differenti
# More info: ?sim.congeneric

set.seed(12341)
n=25 #numero di individui (unità statistiche)
p=4 #numero di misure parallele
D=psych::sim.congeneric(loads = rep(0.35,p),N = n,short=FALSE)
X = D$observed
head(X)
summary(X)

# Stima di VAR[E]
VAR.E = var(apply(X,1,sum))*(1-coef_alpha(X))

# Stima di VAR[T]
VAR.T = var(apply(X,1,sum))*(coef_alpha(X))

## stima dell'attendibilità
rho2_yt = VAR.T/(VAR.T+VAR.E) #uguale a: coef_alpha(X)

## stima del punteggio vero E(T) 
x = apply(X,1,sum)
mu.x = mean(x)
E.T = rho2_yt*x + (1-rho2_yt)*mu.x

x11()
plot(x,bty="n",ylab="punteggi medi osservati",xlab="soggetti",cex=3,ylim=c(min(x)-1,max(x)+1))
points(E.T,col=2,pch=2,cex=3); abline(h = mu.x,lty=2,col=1)
legend("topright",legend = c("osservati","veri"),col = c(1,2),pch=c(1,2),bty = "n")

# Notiamo come i punteggi veri per gli n soggetti sono molto simili tra loro e presentano poca fluttuazione rispetto ai valori osservati. Ciò è dovuto alla bassa
# precisione (rho2_yt) del test nel misurare la quantità di interesse. Inoltre notiamo anche come VAR.E > VAR.T
# Difatti, la correlazione tra le misure parallele è (per come abbiamo costruito gli indicatori x) piuttosto bassa:
D$r

# Proviamo ad aumentare la correlazione tra gli item, cioè tra le variabili osservate. Per far ciò, generiamo le osservate come in precedenza, aumentando questa volta il parametro "loads"
D=psych::sim.congeneric(loads = rep(0.8,p),N = n,short=FALSE) 
X = D$observed

# Procediamo ora a stimare le quantità di interesse della TCT
# Stima di VAR[E]
VAR.E = var(apply(X,1,sum))*(1-coef_alpha(X))

# Stima di VAR[T]
VAR.T = var(apply(X,1,sum))*(coef_alpha(X))

## stima dell'attendibilità
rho2_yt = VAR.T/(VAR.T+VAR.E) #uguale a: coef_alpha(X)

## stima del punteggio vero E(T) 
x = apply(X,1,sum)
mu.x = mean(x)
E.T = rho2_yt*x + (1-rho2_yt)*mu.x

x11()
plot(x,bty="n",ylab="punteggi medi osservati",xlab="soggetti",cex=3,ylim=c(min(x)-1,max(x)+1))
points(E.T,col=2,pch=2,cex=3); abline(h = mu.x,lty=2,col=1)
legend("topright",legend = c("osservati","veri"),col = c(1,2),pch=c(1,2),bty = "n")

# A differenza dei dati precedenti, possiamo notare come in questo caso VAR[T] > VAR[E] unitamente al fatto che la precisione del test rho2_yt è abbastanza alta.
# Conseguentemente, i punteggi stimati tau presentano una maggiore fluttuazione intorno alla loro media. 

# (B) Utilizzo delle quantità stimate tau -------------------------------
# vedi BN(2.8.0)

# Abbiamo visto nella sezione (A) come ottenere i valori veri tau = E[T] per ciascun soggetto a cui è stato somministrato un test. Ora possiamo determinare l'intervallo
# di confidenza ad un livello (1-alpha) fissato per il punteggio stesso, determinando così gli estremi di un intervallo tau_CI = [tau_lb, tau_ub] che conterranno con una probabilità
# (1-alpha) il punteggio vero del soggetto. Per le assunzioni della TCT (i)-(iii), possiamo ragionevolmente assumere che E ~ N(0,VAR[E]) e dunque utilizzare la legge normale
# per determinare gli estremi dell'intervallo tau_CI.
# Definizione: Prob[tau_i-z*sigma.e < tau_i < tau_i+z*sigma.e] = (1-alpha)
# nota: z è il quantile di riferimento (valore critico) della normale standardizzata che corrisponde al livello di probabilità alpha

alpha=0.05 #alpha è 5% 
z = qnorm(p = 1-alpha/2,mean = 0,sd = 1) #poiché la Normale è simmetrica prendiamo il quantile corrispondente a (1-alpha/2) 

# Consideriamo le misurazioni generate nella sezione precedente
set.seed(121)
iid = sample(1:NROW(X),25,replace=FALSE) #prendiamo solo 25 unità statistiche
X = X[iid,]
x = apply(X,1,mean) #punteggi totali osservati (calcolo per media e non somma)
tau = rho2_yt*x + (1-rho2_yt)*mean(x)

# Calcoliamo gli intervalli di confidenza
sigma.e = sd(x)*sqrt(1-coef_alpha(X)) #VAR.E
tau_CI = cbind(tau-z*sigma.e, tau+z*sigma.e)

# Visualizziamo tau e tau_CI
plot(tau,1:length(tau),bty="n",cex=1.25,pch=20,xlab="tau",ylab="soggetti",xlim=c(-2.5,2.5))
points(tau_CI[,1],1:length(tau),col=1,pch=4)
points(tau_CI[,2],1:length(tau),col=1,pch=4)
segments(x0 = tau,x1 = tau_CI[,1],y0 = 1:length(tau),lty=2)
segments(x0 = tau,x1 = tau_CI[,2],y0 = 1:length(tau),lty=2)
abline(v = mean(x),lty=2)





