skew = function (x, na.rm = TRUE, type = 3) 
{
  if (length(dim(x)) == 0) {
    if (na.rm) {
      x <- x[!is.na(x)]
    }
    sdx <- sd(x, na.rm = na.rm)
    mx <- mean(x)
    n <- length(x[!is.na(x)])
    switch(type, {
      skewer <- sqrt(n) * (sum((x - mx)^3, na.rm = na.rm)/(sum((x - 
                                                                  mx)^2, na.rm = na.rm)^(3/2)))
    }, {
      skewer <- n * sqrt(n - 1) * (sum((x - mx)^3, na.rm = na.rm)/((n - 
                                                                      2) * sum((x - mx)^2, na.rm = na.rm)^(3/2)))
    }, {
      skewer <- sum((x - mx)^3)/(n * sd(x)^3)
    })
  }
  else {
    skewer <- rep(NA, dim(x)[2])
    if (is.matrix(x)) {
      mx <- colMeans(x, na.rm = na.rm)
    }
    else {
      mx <- apply(x, 2, mean, na.rm = na.rm)
    }
    sdx <- apply(x, 2, sd, na.rm = na.rm)
    for (i in 1:dim(x)[2]) {
      n <- length(x[!is.na(x[, i]), i])
      switch(type, {
        skewer[i] <- sqrt(n) * (sum((x[, i] - mx[i])^3, 
                                    na.rm = na.rm)/(sum((x[, i] - mx[i])^2, na.rm = na.rm)^(3/2)))
      }, {
        skewer[i] <- n * sqrt(n - 1) * (sum((x[, i] - 
                                               mx[i])^3, na.rm = na.rm)/((n - 2) * sum((x[, 
                                                                                          i] - mx[i])^2, na.rm = na.rm)^(3/2)))
      }, {
        skewer[i] <- sum((x[, i] - mx[i])^3, na.rm = na.rm)/(n * 
                                                               sdx[i]^3)
      })
    }
  }
  return(skewer)
}


kurtosi = function (x, na.rm = TRUE, type = 3) 
{
  if (length(dim(x)) == 0) {
    if (na.rm) {
      x <- x[!is.na(x)]
    }
    if (is.matrix(x)) {
      mx <- colMeans(x, na.rm = na.rm)
    }
    else {
      mx <- mean(x, na.rm = na.rm)
    }
    sdx <- sd(x, na.rm = na.rm)
    n <- length(x[!is.na(x)])
    switch(type, {
      kurt <- sum((x - mx)^4, na.rm = na.rm) * n/(sum((x - 
                                                         mx)^2, na.rm = na.rm)^2) - 3
    }, {
      kurt <- n * (n + 1) * sum((x - mx)^4, na.rm = na.rm)/((n - 
                                                               1) * (n - 2) * (n - 3) * (sum((x - mx)^2, na.rm = na.rm)/(n - 
                                                                                                                           1))^2) - 3 * (n - 1)^2/((n - 2) * (n - 3))
    }, {
      kurt <- sum((x - mx)^4)/(n * sdx^4) - 3
    })
  }
  else {
    kurt <- rep(NA, dim(x)[2])
    mx <- apply(x, 2, mean, na.rm = na.rm)
    if (type == 3) 
      sdx <- apply(x, 2, sd, na.rm = na.rm)
    for (i in 1:dim(x)[2]) {
      n <- length(x[!is.na(x[, i]), i])
      switch(type, {
        kurt[i] <- sum((x[, i] - mx[i])^4, na.rm = na.rm) * 
          length(x[, i])/(sum((x[, i] - mx[i])^2, na.rm = na.rm)^2) - 
          3
      }, {
        xi <- x[, i] - mx[i]
        kurt[i] <- n * (n + 1) * sum((x[, i] - mx[i])^4, 
                                     na.rm = na.rm)/((n - 1) * (n - 2) * (n - 3) * 
                                                       (sum((x[, i] - mx[i])^2, na.rm = na.rm)/(n - 
                                                                                                  1))^2) - 3 * (n - 1)^2/((n - 2) * (n - 3))
      }, {
        kurt[i] <- sum((x[, i] - mx[i])^4, na.rm = na.rm)/((length(x[, 
                                                                     i]) - sum(is.na(x[, i]))) * sdx[i]^4) - 3
      }, {
        NULL
      })
      names(kurt) <- colnames(x)
    }
  }
  return(kurt)
}