rm(list=ls())
set.seed(021222)
n = 1250; p = 10; q = 2; M = 5
# Lambda_str = cbind(c(rep(1,5),rep(0,5)),
#                    c(rep(0,4),rep(1,6)))
Lambda_str = cbind(c(1,1,1,1,1,1,0,0,0,0),c(0,0,0,0,1,1,1,1,1,1))
Lambda = matrix(runif(n = p*q,min = 0,max = 1),nrow = p)*Lambda_str
Phi = clusterGeneration::rcorrmatrix(d = q,alphad = 1)
Thetadelta = diag(1-apply(Lambda,1,function(x)mean(x[x>0]))^2)
Tau = t(apply(matrix(runif((M-1)*p,-2,2),nrow = p),1,sort))
Eta = mvtnorm::rmvnorm(n = n,sigma = Phi)
Delta = mvtnorm::rmvnorm(n = n,sigma = Thetadelta)
Ystar = Eta%*%t(Lambda) + Delta #CFA linear equation
Y = mapply(function(j)as.numeric(cut(x = Ystar[,j],breaks = c(-Inf,Tau[j,],Inf),right=TRUE,labels = seq(1,NCOL(Tau)+1))),1:NCOL(Ystar))    

dataobs = data.frame(Y) #keep current dataset of observed variables
colnames(dataobs) = vars = paste0("item",1:p)
for(j in 1:NCOL(dataobs)){dataobs[,j]=factor(x = dataobs[,j],ordered = TRUE)}
Lambda_str = Lambda>0
lav_model = paste(mapply(function(j)paste0(paste0("eta",j),"=~",paste(vars[Lambda_str[,j]],collapse="+")),1:NCOL(Lambda_str)),collapse=" \n ")

mod_fit = lavaan::cfa(model = lav_model,data = dataobs,ordered = vars,estimator="DWLS",std.lv=TRUE)
summary(mod_fit,standardized=TRUE)

Lambda_est = lavaan::lavInspect(object = mod_fit,what = "est")$lambda
Phi_est = lavaan::lavInspect(object = mod_fit,what = "est")$psi
Thetadelta_est = diag(lavaan::lavInspect(object = mod_fit,what = "est")$theta)

modificationindices(mod_fit)
fitMeasures(mod_fit)

write.csv(x = Y,file = "MEGA/Lavoro_sync/Didattica/2022_2023/testing_psicologico/esercizi/data_ex4.csv",row.names = FALSE)


colnames(S) = rownames(S) = paste0("Y",1:10)
mod1_def = "eta1 =~ Y1+Y2+Y3+Y4+Y5 \n eta2 =~ Y6+Y7+Y8+Y9+Y10 \n eta1~~0*eta2"
#mod2_def = "eta1 =~ Y1+Y2+Y3+Y4+Y5+Y6 \n eta2 =~ Y5+Y6+Y7+Y8+Y9+Y10"
mod1_fit = cfa(model = mod1_def,sample.cov = S,sample.nobs = 1250)
#mod2_fit = cfa(model = mod2_def,sample.cov = S,sample.nobs = 1250)

x11();plot_lavaan_model(mod1_fit)

head(modificationindices(mod1_fit,sort. = TRUE))

mod1_def = "eta1 =~ Y1+Y2+Y3+Y4+Y5 \n eta2 =~ Y5+Y6+Y7+Y8+Y9+Y10 \n eta1~~0*eta2"
mod1_fit_b = cfa(model = mod1_def,sample.cov = S,sample.nobs = 1250)
head(modificationindices(mod1_fit_b,sort. = TRUE))

mod1_def = "eta1 =~ Y1+Y2+Y3+Y4+Y5 \n eta2 =~ Y5+Y6+Y7+Y8+Y9+Y10 \n eta1~~eta2"
mod1_fit_c = cfa(model = mod1_def,sample.cov = S,sample.nobs = 1250)
head(modificationindices(mod1_fit_c,sort. = TRUE))

fitmeasures(object = mod1_fit,fit.measures = c("CFI","RMSEA"))

save(S,file = "MEGA/Lavoro_sync/Didattica/2022_2023/testing_psicologico/esercizi/data_ex5.Rdata")




