#######################################################################
## Testing psicologico (PSP6075525)
### Modelli e metodi statistici per la misurazione in psicologia
## A.A. 2023/2024
## prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################################


## CONTENUTO DEL CODICE ###############################################
# (A) Vettori e Matrici
# (B) Operazioni tra matrici
# (C) Grafici di matrici
# (D) Dalle matrici ai dataframe
#######################################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2023_2024/testing_psicologico/laboratorio/") #change it according to your local path!
library(matrixcalc)
library(plot.matrix)


# (A) Vettori e Matrici ---------------------------------------------------
# Il modo più semplice di definire un vettore in R è mediane l'utilizzo dell'operatore: c()
x = c(2,3,1)
print(x)

y = c(1,1,2)
z = c(x,y) #in questo caso, c() concatena due vettori di lunghezza differente
print(z)

y = c("a","b","pippo","pluto") #un vettore di elementi non numerici
print(y)

z = c(x,y)  #concatenazione di vettori con elementi diversi
print(z)    #in questo caso gli elementi del vettore x vengono trasformati in lettere
            #Nota: vettori e matrici devono essere dello stesso tipo!

typeof(x)   #vettore x è 'double', numerico
typeof(z)   #vettore z è character

x = matrix(data = c(1,1,2,3,1,5),ncol=1) #vettore colonna
print(x) 

y = matrix(data = c(1,1,2,3,1,5),nrow=1) #vettore riga
print(y) 

# La differenza tra c() e matrix() consiste nel fatto che c() è un operatore generico che permette in generale di concatenare elementi anche diversi tra loro.
# Inoltre c() non distingue tra vettore riga o colonna e R interpreta l'array generato da c() come vettore riga o colonna a seconda dei contesti d'uso.

X = matrix(data = c(1,2,3,4,5,6),nrow = 3,ncol = 3,byrow = FALSE)
print(X)
# Il parametro byrow=FALSE (default in R) popola la matrice X nella direzione delle righe (row-wise) tenendo fisse le colonne di volta in volta.

X = matrix(data = c(1,2,3,4,5,6),nrow = 3,ncol = 3,byrow = TRUE)
print(X)
# Il parametro byrow=TRUE popola la matrice X nella direzione delle colonne (column-wise) tenendo fisse le righe di volta in volta.

X = matrix(data = c(1,2,3,4,5,6),nrow = 4,ncol = 2)
# Il numero di righe (n) e colonne (m) deve concordare con il numero di elementi totali da disporre!

x = c(1,4,2,1,8,7,0,1)
X = matrix(data = x,nrow = 2) #se non specificato, il parametro ncol è calcolato in automatico (dato nrow)
print(X)

X = matrix(data = x,ncol = 2) #se non specificato, il parametro nrow è calcolato in automatico (dato ncol)
print(X)

X = matrix(data = x,ncol = 2,nrow = 2)
print(X)
diag(X) #estrae la diagonale principale se X è una matrice
diag(x) #costruisce una matrice diagonale con gli elementi di x se x è un vettore! 
        #Nota: attenzione all'utilizzo di diag(), il suo comportamento dipende dall'input.

diag(diag(X)) #dall'interno verso l'esterno: la prima volta diag() estrae la diagonale di X (il cui output è un vettore), 
              #la seconda volta costruisce una matrice diagonale con l'output precedente

set.seed(121) #fissiamo il seme di generazione casuale (per la riga successiva)
x = runif(16) #generiamo 16 numeri casuali distribuiti uniformemente
X = matrix(data = x,nrow = 4)
print(X)

t(X) #trasposta di X

X[lower.tri(X)]               #estrae gli elementi del triangolo inferiore di X (l'output è un vettore)
matrixcalc::lower.triangle(X) #estrae gli elementi del triangolo inferiore di X (l'output è una matrice)

X[upper.tri(X)]               #estrae gli elementi del triangolo superiore di X (l'output è un vettore)
matrixcalc::upper.triangle(X) #estrae gli elementi del triangolo inferiore di X (l'output è una matrice)

sum(diag(X))                  #traccia di X
matrixcalc::matrix.trace(X)   #traccia di X

det(X)                        #determinante di X
matrixcalc::matrix.rank(X)    #rango di X
qr(X)$rank                    #rango di X

solve(X)                      #inversa di X
matrixcalc::matrix.inverse(X) #inversa di X

x = runif(9) 
X = matrix(data = x,nrow = 3)
X[lower.tri(X)] = X[upper.tri(X)]   #il triangolo inferiore di X conterrà gli stessi elementi del triangolo superiore di X
matrixcalc::is.symmetric.matrix(X)  #la matrice risultante è simmetrica



# (B) Operazioni tra matrici ----------------------------------------------

V = matrix(data = runif(8),nrow = 2)
X = matrix(data = runif(16),nrow = 4)
Y = matrix(data = runif(16),nrow = 4)

Z = X+Y        #somma
Z = X-Y        #differenza
print(Z)

Z = X*Y        #prodotto elemento-per-elemento (Hadamard)
print(Z)

Z = X%*%t(V)   #prodotto riga-colonna
print(Z)

Z = X%*%Y      #prodotto riga-colonna
print(Z)

Z = X%*%t(Y)   #prodotto riga-colonna
print(Z)

Z = V%*%Y      #prodotto riga-colonna
print(Z)


v = V[1,]      #prima riga di V
Z = X%*%v      #prodotto riga-colonna
print(Z)

a = matrix(data = 1,nrow = NROW(X))   #vettore colonna di 1
z = X%*%a      #somma di X column-wise
               #equivale a: apply(X,1,sum) oppure rowSums(X)

z = t(a)%*%X   #somma di X row-wise
               #equivale a: apply(X,2,sum) oppure colSums(X)

z = t(a)%*%X%*%a   #somma di X 
                   #equivale a: sum(X)

z = t(v)%*%v       #somma del quadrato di v
                   #equivale a: sum(v^2)

Z = v%*%t(v)       #matrice simmetrica con diagonale uguale al quadrato di v
is.symmetric.matrix(Z)
diag(Z) == v^2

Z = X%*%v%*%t(v) + solve(Y)   #più operazioni insieme
Z = X%*%solve(Y)
Z = t(v)%*%X-t(Y%*%v)




# (C) Grafici di matrici --------------------------------------------------

x11()     #crea una nuova finestra grafica -- per Linux & Windows; per utenti macOs: usare quartz() 
par(mar=c(5.1, 4.1, 4.1, 4.1)) # adapt margins (for nice plots only!)
plot(X)   #magnitudine degli elementi mediante gradiente del colore

x = sample(x = c(-1,1),size = 9,replace = TRUE)
X = matrix(data = x,nrow = 3)
x11()     #crea una nuova finestra grafica -- per Linux & Windows; per utenti macOs: usare quartz() 
par(mar=c(5.1, 4.1, 4.1, 4.1)) # adapt margins (for nice plots only!)
plot(X,border=NA)

set.seed(212)
x = runif(n = 100,min = -10,max = 10)
X = matrix(data = x,nrow = 25)
x11()     #crea una nuova finestra grafica -- per Linux & Windows; per utenti macOs: usare quartz() 
par(mar=c(5.1, 4.1, 4.1, 4.1)) # adapt margins (for nice plots only!)
x11();plot(X[,1:2],border=NA)


# (D) Dalle matrici ai dataframe ------------------------------------------

D = data.frame(X) # crea un dataframe da una matrice numerica
# Il dataframe è una struttura dati che - a differenza delle matrici - consente l'aggregazione di variabili di tipo diverso (es.: stringhe, numeri).
# Inoltre questo tipo di dato consente una maggiore flessibilità nell'effettuare alcune operazioni in R (es.: costruzione di grafici, uso di funzioni più
# propriamente statistiche).

x1 = runif(n = 10,min = 0,max = 2)       #definiamo una prima variabile
x2 = x1 + runif(n = 10,min = 0,max = 2)  #definiamo una seconda variabile combinazione della prima e di un errore uniforme
x3 = x1*0.9 + x2*1.1                     #definiamo una terza variabile combinazione lineare delle prime due

D = data.frame(var1=x1, var2=x2, var3=x3)
str(D) #funzione usata per visualizzare la 'struttura' del dataframe

D = data.frame(pippo=x1, pluto=x2, paperino=x3)  #i nomi delle variabili non sono un problema
str(D)

# Inoltre, con in dataframe c'è la possibilità di associare a ciascuna riga e a ciascuna colonna un identificativo tipo stringa.
# Ad esempio:
colnames(D) = c("lupin", "zenigata", "margot")   #cambiamo in nomi delle colonne/variabili
rownames(D) = paste0("sbj",1:10)                 #la funzione paste0() consente di 'incollare' la stringa sbj a una sequenza di dieci interi
str(D)
head(D)

# Rispetto alle matrici, un modo alternativo per accedere alle variabili/colonne del dataframe è il seguente:
D[,1]    #estrae la prima colonna mediante indice
D$pippo  #estrae la prima colonna mediante identificativo (chiamandola per nome)

z = 0.98*D[,1] - 2.1*D[,2]       #variabile 'z' ottenuta per somma row-wise delle prime due variabili di D
z = 0.98*D$pippo - 2.1*D$pluto   #sintassi equivalente







