#######################################################################
## Testing psicologico (PSP6075525)
### Modelli e metodi statistici per la misurazione in psicologia
## A.A. 2023/2024
## prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################################


## CONTENUTO DEL CODICE ###############################################
# (A) Analisi esplorative vs. confermative
# (B) Validazione incrociata 1
# (C) Validazione incrociata 2
#######################################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2023_2024/testing_psicologico/laboratorio/") #change it according to your local path!
library(lavaan); library(semPlot)
source("utilities.R")


# (A) Analisi esplorative vs. confermative --------------------------------
srs = read.csv(file = "data/srs.csv",header = TRUE)[,2:21] #non consideriamo la prima colonna
srs = scale(srs)                                           #standardizzazione
apply(srs,2,function(x)c(mean(x),var(x)))                  #controllo finale

out = split_dataset(data = srs,prop = 0.4,seedx = 112)     #divisione a metà del dataset (primo sottoinsieme: 40% dei dati originali)
srs_A = out$A       #dataset per le analisi esplorative
srs_B = out$B       #dataset per le analisi confermative

## Analisi esplorative
library(corrplot); 
x11();corrplot.mixed(corr = cor(srs_A), upper = "circle")
cols = colorRampPalette(c("blue", "white", "red"))(20)
x11();stats::heatmap(x = cor(srs_A), col = cols, symm = TRUE)

model1 = paste0("eta=~",paste0(colnames(srs),collapse = "+"))
model2 = "eta1=~V11+V17+V14+V13+V4+V3+V18+V1+V2+V8 \n eta2=~V12+V15+V9+V5+V7+V16+V6+V20+V10+V19"

## Analisi confermative
model1_fit = cfa(model = model1,data = srs_B)
summary(model1_fit,standardized=TRUE)
fitmeasures(object = model1_fit,fit.measures = c("rmsea","cfi","npar","srmr"))

model2_fit = cfa(model = model2,data = srs_B)
summary(model2_fit,standardized=TRUE)
fitmeasures(object = model2_fit,fit.measures = c("rmsea","cfi","npar","srmr"))

anova(model1_fit,model2_fit,test="Chisq")
fitMeasures_models(c(model1_fit,model2_fit))

# (B) Validazione incrociata 1 ---------------------------------------------
## Nota: questa sezione mostra step-by-step come funziona ed è implementata la funzione 
## kFold_validation() presente nel file utilities.R (Può essere saltata se non si è interessati a comprenderne il funzionamento).
## L'obiettivo qui è descrivere come la funzione opera per il calcolo dell'errore previsionale prodotto da due modelli CFA utilizzando
## la logica della validazione incrociata (cross-validation).

n = NROW(srs)                                         #numero di unità stats del dataset
B = 100                                               #numero di repliche Monte Carlo (per il calcolo dell'errore di previsione)
nfold = 5                                             #numero di partizioni del dataset originario
Output1 = matrix(NA, nrow = nfold, ncol = B)           
Output2 = matrix(NA, nrow = nfold, ncol = B)           
folds = cut(seq(1,n), breaks=nfold, labels=FALSE)
print(cbind(1:n,folds))

for(h in 1:nfold){
  iid = which(folds==h)         #indici per la h-esima partizione (sottoinsieme corrente)
  not_iid = setdiff(1:n,iid)
  test = srs[iid,]              #dataset di training
  train = srs[not_iid,]         #dataset di test
  
  model1_train = cfa(model = model1,data = train)   #adattamento del modello 1 al dataset di training
  model2_train = cfa(model = model2,data = train)   #adattamento del modello 2 al dataset di training
  
  out = lavInspect(object = model1_train,what = "est")    #calcolo della matrice di cov riprodotta dal modello 1
  Lambda = out$lambda; Phi = out$psi; Thetad = out$theta
  Sigma_hat1 = Lambda%*%Phi%*%t(Lambda) + Thetad
  
  out = lavInspect(object = model2_train,what = "est")    #calcolo della matrice di cov riprodotta dal modello 2
  Lambda = out$lambda; Phi = out$psi; Thetad = out$theta
  Sigma_hat2 = Lambda%*%Phi%*%t(Lambda) + Thetad
  
  err = rep(NA,B)                                        #calcolo della distanza tra cov del dataset di test e cov del b-esimo dataset generato da modello vero
  for(b in 1:B){                                         #errore di previsione
    data_predicted = mvtnorm::rmvnorm(n,sigma = Sigma_hat1)
    Output1[h,b] =  norm(cov(data_predicted)-cov(test))
    
    data_predicted = mvtnorm::rmvnorm(n,sigma = Sigma_hat2)
    Output2[h,b] =  norm(cov(data_predicted)-cov(test))  
  }
  
}
err1 = apply(Output1,1,mean) #errore di previsione medio su B campioni simulati - modello 1
err2 = apply(Output2,1,mean) #errore di previsione medio su B campioni simulati - modello 2
Err = cbind(err1,err2)
print(Err)
summary(Err)

apply(Err,2,mean)
apply(Err,2,sd)/apply(Err,2,mean)

# Scelta di nfold: non deve essere troppo alto il numero di partizioni se n è piccolo!
n/nfold
# In questo caso ogni partizione avrà un dataset di 100 unità su cui fare il training del modello.
# Per una discussione sul tema, si veda: 
# https://stats.stackexchange.com/questions/61783/bias-and-variance-in-leave-one-out-vs-k-fold-cross-validation/357749#357749



# (C) Validazione incrociata 2 --------------------------------------------
nfold = 5; B = 100;
err1 = kFold_validation(model_definition = model1,data = srs_B,error = "montecarlo",B = B,nfold = nfold)
err2 = kFold_validation(model_definition = model2,data = srs_B,error = "montecarlo",B = B,nfold = nfold)

Err = cbind(err1,err2)
print(Err)
summary(Err)

apply(Err,2,mean)
apply(Err,2,sd)/apply(Err,2,mean)







