  #######################################################################
## Testing psicologico (PSP6075525)
### Modelli e metodi statistici per la misurazione in psicologia
## A.A. 2023/2024
## prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################################


## CONTENUTO DEL CODICE ###############################################
# (A) Dati
# (B) Analisi esplorative
# (C) Definizione dei modelli
# (D) CFA: adattamento dei modelli ai dati
# (E) CFA: valutazione dell'adattamento dei modelli ipotizzati
# (F) CFA: valutazione dell'errore di previsione dei modelli adattati
# (G) Miglioramento del modello CFA
# (H) Semplificazione del modello CFA
# (I) Valutazione struttura bifattoriale
# (L) Valutazione struttura di secondo ordine
#######################################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2023_2024/testing_psicologico/laboratorio/") #change it according to your local path!
library(lavaan); library(semTools); library(qgraph); library(corrplot); library(psych)
source("utilities.R")


# (A) Dati ----------------------------------------------------------------
load("data/lab12.Rdata")
p = NCOL(datay)-1
class(datay) # il dataset è sotto forma di matrice. Convertiamolo in dataframe
datay = data.frame(datay)
str(datay)

vars = names(datay)
datay[,1:(p-1)] = scale(datay[,1:(p-1)]) 

out = split_dataset(data = datay,prop = 0.6,seedx = 1211)
datay_A = out$A
datay_B = out$B


# (B) Analisi esplorative -------------------------------------------------

psych::describeBy(x = datay_A[,1:p],group = datay_A[,10])

x11(); par(mfrow=c(3,3)) # distribuzioni degli item rispetto alla variabile gruppo
for(j in 1:p){
  boxplot(formula=datay_A[,j]~datay_A[,10],col=c("lightgray","lightblue"),xlab="",ylab="",main=vars[j],frame=FALSE)
}

gp0=datay_A[,10]=="0"; gp1=datay_A[,10]=="1"          # variabile indicatrice per i gruppi

## Calcolo della reliability mediante indice di Cronbach e punteggi totali pesati
a_gp0 = computeAlpha(S = cov(datay_A[gp0,1:p]),p)     # reliability per gruppo z=0
a_gp1 = computeAlpha(S = cov(datay_A[gp1,1:p]),p)     # reliability per gruppo z=1
mx_gp0 = mean(apply(datay_A[gp0,1:p],2,mean))         # media complessiva per gruppo z=0
mx_gp1 = mean(apply(datay_A[gp1,1:p],2,mean))         # media complessiva per gruppo z=1
txRaw_gp0 = apply(datay_A[gp0,],1,sum)                # punteggi grezzi via somma per gruppo z=0
txRaw_gp1 = apply(datay_A[gp1,],1,sum)                # punteggi grezzi via somma per gruppo z=1
tx_gp0 = txRaw_gp0*a_gp0 + (1-a_gp0)*txRaw_gp0        # punteggi pesati rispetto ad alpha per gruppo z=0
tx_gp1 = txRaw_gp1*a_gp1 + (1-a_gp1)*txRaw_gp1        # punteggi pesati rispetto ad alpha per gruppo z=1

x11(); # distribuzioni dei punteggi pesati per entrambi i gruppi
plot(density(tx_gp0),bty="n",xlab="",ylab="",main="",col="blue")
lines(density(tx_gp1),bty="n",xlab="",ylab="",main="",col="red")
legend("topleft",legend = c("gp0","gp0"),fill = c("blue","red"),bty = "n")

## Analisi della matrice di correlazione
cor_gp0 = cor(datay_A[gp0,1:p])                      # cor per gruppo z=0
cor_gp1 = cor(datay_A[gp1,1:p])                      # cor per gruppo z=1

x11();par(mfrow=c(1,3))                              # grafici delle matrici di correlazione
corrplot(corr = cor_gp0,method = "color")
corrplot(corr = cor_gp1,method = "color")
corrplot(corr = cor_gp0-cor_gp1,method = "color")    # grafico matrice delle differenze

hc_gp0 = hclust(d = dist(cor_gp0),method = "ward.D2")   # clustering gerarchico per gruppo z=0
hc_gp1 = hclust(d = dist(cor_gp1),method = "ward.D2")   # clustering gerarchico per gruppo z=1
x11();par(mfrow=c(1,2)); 
plot(hc_gp0,main="gp0"); plot(hc_gp1,main="gp1")

# scelta della soluzione agglomerativa: ..due,tre,quattro gruppi?
compute_silhouette(dist_data = dist(cor_gp0),hclust_out = hc_gp0,nclusters = c(2,3,4,5,6,7,8))
compute_silhouette(dist_data = dist(cor_gp1),hclust_out = hc_gp1,nclusters = c(2,3,4,5,6,7,8))

gps_gp0 = cutree(tree = hc_gp0,k = 2); gps_gp1 = cutree(tree = hc_gp1,k = 2)     # estrazione dei gruppi

x11(); par(mfrow=c(1,2))      # grafico a rete per entrambe le matrici di correlazione
qgraph(input = cor_gp0,minimum=0.05,vsize=10,legend=TRUE,borders=FALSE,groups=list(A=which(gps_gp0==1),B=which(gps_gp0==2),C=which(gps_gp0==3)),
       theme="classic")
qgraph(input = cor_gp1,minimum=0.05,vsize=10,legend=TRUE,borders=FALSE,groups=list(A=which(gps_gp1==1),B=which(gps_gp1==2),C=which(gps_gp1==3)),
       theme="classic") 



# (C) Definizione dei modelli ---------------------------------------------
# Nota: i modelli definiti in questa sezione non tengono conto della presenza della variabile di classificazione 'gp'
cor_A = cor(datay_A[,1:p])

## Clustering gerarchico
hc_ward = hclust(d = dist(cor_A),method = "ward.D2")
hc_avg = hclust(d = dist(cor_A),method = "average")
  
x11(); par(mfrow=c(1,2));  #dendrogrammi
plot(hc_ward,main="ward"); plot(hc_avg,main="average")

compute_silhouette(dist_data = dist(cor_A),hclust_out = hc_ward,nclusters = 2:5)
compute_silhouette(dist_data = dist(cor_A),hclust_out = hc_avg,nclusters = 2:5)

# Entrambi i metodi convergono sulla medesima soluzione di aggregazione
mod_hc1 = hclust2lavaan(tree = hc_ward,ngroups = 2)
mod_hc2 = hclust2lavaan(tree = hc_avg,ngroups = 2)
# Nota: Le soluzioni sono identiche: possiamo scegliere un modello al posto dell'altro

## PCA (non affrontata quest'anno)
# out = prcomp(cor_A)
# cumsum(out$sdev)/sum(out$sdev) 
# scegliamo tre soluzioni: k={2,3,4}

# mod_pca1 = prcomp2lavaan(prcomp_output = out,numPC = 2,rotate = "varimax",thr = 0) 
# mod_pca2 = prcomp2lavaan(prcomp_output = out,numPC = 3,rotate = "varimax",thr = 0)
# mod_pca3 = prcomp2lavaan(prcomp_output = out,numPC = 4,rotate = "varimax",thr = 0)
# Nota: thr=0 permette di non escludere variabili osservate in questo caso. Ciò si rende necessario per ragioni di comparabilità tra i diversi modelli
# (tutti i modelli oggetto di confronto devono avere la stessa matrice di covarianza osservata)

## Modello unidimensionale ('modello di base' per il confronto)
mod_uni = hclust2lavaan(tree = hc_ward,ngroups = 1) 
# sintassi veloce per ottenere un modello unidimensionale (al posto di scriverlo variabile per variabile)


# (D) CFA: adattamento dei modelli ai dati --------------------------------

# Il dataset contiene la variabile di raggruppamento dicotomica 'gp' (j=10). Per tenerne conto nell'adattamento del modello CFA ai dati
# occorre specificare nella funzione cfa(..,group = datay_B[,10]). In tal modo lavaan stima tanti modelli cfa quanti sono i livelli della variabile
# categoriale (quanti sono i gruppi in questo caso). Non specificare il parametro 'group' anche in presenza di variabili di stratificazione del campione
# significa non tenere conto di tale informazione. Procediamo, per ora, ignorando tale informazione e adattiamo un modello cfa sul campione complessivo.

# Nota: utilizzare il dataset corretto (seconda parte del dataset)!

fit_hc1 = cfa(model = mod_hc1,data = datay_B) 
lavaan_checkConvergence(fit_hc1)

# (non effettuata quest'anno)
#fit_pca1 = cfa(model = mod_pca1,data = datay_B)
# L'algoritmo di stima non converge per questo modello. 
# (opzionale) I motivi possono essere indagati tramite la funzione lavaan_checkConvergence():
#lavaan_checkConvergence(fit_pca1) # questo modello deve essere scartato

#fit_pca2 = cfa(model = mod_pca2,data = datay_B)
# L'algoritmo di stima non converge per questo modello. 
# (opzionale) I motivi possono essere indagati tramite la funzione lavaan_checkConvergence():
#lavaan_checkConvergence(fit_pca2) # questo modello deve essere scartato

#fit_pca3 = cfa(model = mod_pca3,data = datay_B)
# L'algoritmo di stima non converge per questo modello. 
# (opzionale) I motivi possono essere indagati tramite la funzione lavaan_checkConvergence():
#lavaan_checkConvergence(fit_pca3) # questo modello deve essere scartato

fit_uni = cfa(model = mod_uni,data = datay_B) # convergenza: ok
lavaan_checkConvergence(fit_uni)


# (E) CFA: valutazione dell'adattamento dei modelli ipotizzati ------------

models = c(fit_hc1,fit_uni)
fit_table = fitMeasures_models(models = models)
print(fit_table)  
# Nessuno dei modelli ipotizzati si adatta bene ai dati stando agli indici di fit utilizzati. 
# Solo il secondo modello presenta indici {rmsea,srmr,cfi} relativamente migliori sebbene fuori range.
# Questo risultato è concorde anche con l'indice AIC (criterio del minore valore). La parsimoniosità del secondo modello
# è paragonabile a quella degli altri modelli, utilizzando poco più del 40% del numero di parametri totali. 



# (F) CFA: valutazione dell'errore di previsione dei modelli adatt --------

# Le analisi di fit non sono state conclusive rispetto alla scelta del modello migliore. Il secondo modello, qualora scelto,
# dovrà subire dei miglioramenti o semplificazioni in modo da ottenere un modello di misura accettabile.
# Valutiamo in questa sezione l'errore di previsione dei modelli CFA precedenti (scegliamo B sufficientemente elevato).

kf_hc1 = kFold_validation(model_definition = mod_hc1,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)
kf_uni = kFold_validation(model_definition = mod_uni,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)

# Analisi distribuzionale degli errori di previsione
kf_table = rbind(kf_hc1,kf_uni) # creiamo row-wise una matrice con i risultati della validazione incrociata (righe: modelli; colonne: ripetizioni Monte Carlo)
kf_mx = apply(kf_table,1,mean) # errore medio dei tre modelli
kf_sd = apply(kf_table,1,sd)   # errore medio dei tre modelli
rbind(kf_mx,kf_sd,kf_sd/kf_mx) # visualizziamo i risultiati aggiungendo anche il cv

# Il secondo modello non è quello che produce un errore medio di previsione più basso (in questo caso è il modello unidimendionale a raggiungere tale risultato)
# tuttavia esso presenta errori di previsione meno variabili rispetto agli altri due (conseguentemente il coeff di variazione cv + più basso).
# L'errore di previsione suggerisce dunque la scelta del secondo modello sebbene esso necessiti ancora di ulteriori miglioramenti.



# (G) Miglioramento del modello CFA ---------------------------------------

x11(); plot_lavaan_model(fitted_model = fit_hc1,what = "std")

## Miglioramento tramite indici di modifica
out = modificationIndices(object = fit_hc1,sort. = TRUE)
head(out)

# Definiamo un nuovo modello aggiugendo i due cross-loadings con mi più elevato
mod_hc1_a = "eta1 =~ Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group+First.Letters \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences+Suffixes+Sentences"

fit_hc1_a = cfa(model = mod_hc1_a,data = datay_B)
summary(fit_hc1_a)

fitMeasures_models(models = c(fit_hc1,fit_hc1_a,fit_uni)) # confrontiamo il nuovo modello con l'originale fit_hc1 e quello unidimensionale
# lavaan::lavTestLRT(fit_hc1,fit_hc1_a) 
# L'aggiunta dei cross-loadings ha portato a un miglioramento lieve dell'adattamento complessivo del modello (rispetto all'ultimo modello). 

# Continuiamo con l'aggiunta di parametri liberi al modello mediante indici di modifica
out = modificationIndices(object = fit_hc1_a,sort. = TRUE)
head(out)

mod_hc1_b = "eta1 =~ Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group+First.Letters \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences+Suffixes+Sentences+First.Letters"

fit_hc1_b = cfa(model = mod_hc1_b,data = datay_B)
summary(fit_hc1_b)

fitMeasures_models(models = c(fit_hc1,fit_hc1_a,fit_hc1_b,fit_uni)) # confrontiamo il nuovo modello con l'originale fit_hc1 e quello unidimensionale
# L'aggiunta del cross-loading ha portato a un miglioramento non banale dell'adattamento complessivo del modello (rispetto all'ultimo modello). 

# Continuiamo con l'aggiunta di parametri liberi al modello mediante indici di modifica
out = modificationIndices(object = fit_hc1_b,sort. = TRUE)
head(out)

mod_hc1_c = "eta1 =~ Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group+First.Letters \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences+Suffixes+Sentences+First.Letters \n
Four.Letter.Words~~First.Letters"

fit_hc1_c = cfa(model = mod_hc1_c,data = datay_B)
summary(fit_hc1_c)

fitMeasures_models(models = c(fit_hc1,fit_hc1_a,fit_hc1_b,fit_hc1_c,fit_uni)) # confrontiamo il nuovo modello con l'originale fit_hc1 e quello unidimensionale
# L'aggiunta del cross-loading ha portato a un miglioramento lieve dell'adattamento complessivo del modello (rispetto all'ultimo modello). 

kf_hc1_a = kFold_validation(model_definition = mod_hc1_a,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)
kf_hc1_b = kFold_validation(model_definition = mod_hc1_b,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)
kf_hc1_c = kFold_validation(model_definition = mod_hc1_c,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)

# Analisi distribuzionale degli errori di previsione
kf_table = cbind(kf_hc1,kf_hc1_a,kf_hc1_b,kf_hc1_c,kf_uni); colnames(kf_table) = c("mod_hc1","mod_hc1_a","mod_hc1_b","mod_hc1_c","mod_uni")
kf_mx = apply(kf_table,2,mean); kf_sd = apply(kf_table,2,sd) #calcolo di medie e dev stds
rbind(kf_mx,kf_sd,kf_sd/kf_mx) #medie, dev stds, coeff variazione
x11(); boxplot(kf_table)
# L'errore di previsione del modello mod_hc1_a è quello con meno varianza di errore di previsione sebbene in media il modello sbagli di più di mod_uni

x11(); plot_lavaan_model(fitted_model = fit_hc1_a,what = "std")


# (H) Semplificazione del modello -----------------------------------------
# Il modello fit_hc1_a presenta complessivamente indici di adattamento globali ancora migliorabili. 
# Procediamo questa volta tramite semplificazione del modello.

summary_table(fitted_model = fit_hc1_a,type_summary = "all")
# Iniziamo semplifando la matrice Lambda, eliminando quei legami o variabili che presentano un loading inferiore in valore assoluto alla soglia 0.40:
# eta2 =~ Suffixes

mod_hc1_a_a = "eta1 =~ First.Letters+Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences"

fit_hc1_a_a = cfa(model = mod_hc1_a_a,data = datay_B)
# Nota: in generale l'eliminazione di variabili osservate (ie, di legami tra osservate e latenti) fa diminuire il numero di variabili su cui la matrice di cov
# osservata è calcolata. In questi casi, il confronto con i modelli precedenti (ie, quelli in cui la variabile non era stata eliminata) non può essere fatta
# poiché i modelli non condividono la stessa matrice di cov osservata. 
# In questo caso, tuttavia, l'eliminazione del legame eta2=~Suffixes non elimina la variabile osservata Suffixes in quanto questa presente mediante il legame
# eta1=~Suffixes. La procedura di semplificazione ha dunque eliminato un croass-loading mantendendo la variabile osservata nel modello. 
# In questo caso, dunque, il confronto con i modelli precedenti può essere fatto (la matrice di cov osservata non è difatti cambiata).

# Successivamente proviamo ad eliminare il legame di correlazione tra le latenti (il parametro stimato è minore dela soglia indicativa 0.40)
mod_hc1_a_b = "eta1 =~ First.Letters+Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences \n
eta2~~0*eta1"
fit_hc1_a_b = cfa(model = mod_hc1_a_b,data = datay_B)
fitMeasures_models(models = c(fit_hc1_a_a,fit_hc1_a_b)) 
# Tra i due modelli semplificati, mod_hc1_a_a si adatta meglio ai dati di mod_hc1_a_b
# Facendo un confronto con il modello parent (è possibile solo in quanto la matrice di cov osservata non cambia!)
fitMeasures_models(models = c(fit_hc1_a,fit_hc1_a_a,fit_hc1_a_b)) 

# Consideriamo il modello fit_hc1_a_a per le analisi successive. Valutiamo se tale modello necessiti di una struttura bi-factor.

# (I) Valutazione struttura bifattoriale ----------------------------------

# Modello bi-factor con ortogonalità completa
mod_hc1_bi = "eta1 =~ First.Letters+Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences \n
eta0 =~ Sentences+Vocabulary+Sent.Completion+First.Letters+Four.Letter.Words+Suffixes+Letter.Series+Pedigrees+Letter.Group \n
eta1~~0*eta0 \n eta2~~0*eta0 \n eta1~~0*eta2"

fit_hc1_bi = cfa(model = mod_hc1_bi,data = datay_B) #modello ortogonale completo
lavaan_checkConvergence(fit_hc1_bi)
summary(fit_hc1_bi)

# Modello bi-factor con ortogonalità parziale
# Nota: questo modello ha senso quando il modello precedente non ottiene convergenza in fase di stima. In questo caso si riporta comunque il modello 
# per ragioni didattiche (si veda la sintassi utilizzata!)
mod_hc1_bi_parz = "eta1 =~ First.Letters+Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences \n
eta0 =~ Sentences+Vocabulary+Sent.Completion+First.Letters+Four.Letter.Words+Suffixes+Letter.Series+Pedigrees+Letter.Group \n
eta1~~0*eta0 \n eta2~~0*eta0"

fit_hc1_bi_parz = cfa(model = mod_hc1_bi_parz,data = datay_B)
lavaan_checkConvergence(fit_hc1_bi_parz)
# La seconda versione bi-factor del modello hc_a non ha convergenza. 

# Confrontiamo il modello bi-factor (ortog completa) con il modello non bifactor 
fitMeasures_models(models = c(fit_hc1_a_a,fit_hc1_bi)) 

kf_hc1_a_a = kFold_validation(model_definition = mod_hc1_a_a,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)
kf_hc1_bi = kFold_validation(model_definition = mod_hc1_bi,data = datay_B[,1:p],nfold = 7,force_crossValid = TRUE,error = "montecarlo",B = 1000)

out = cbind(kf_hc1_a_a,kf_hc1_bi)
x11(); boxplot(out)
apply(out,2,mean)
apply(out,2,sd)

#Il modello bifactor con ortog completa si adatta meglio ai dati e presenta minore errore medio di previsione e minore varianza di errore. 
#Le differenze con il modello non bifactor risultano tuttavia di lieve entità.
#Se ragioni interpretative lo permettono, il modello bifactor potrebbe essere scelto rispetto al modello di confronto sebbene la struttura non bifactor
#sia più parsimoniosa e più semplice da interpretare. La scelta è dunque demandata sulla base di ragioni teoriche e di contesto.


# (L) Valutazione struttura di secondo ordine -----------------------------

# Per ragioni didattiche, procediamo valutando se il modello hc1_a_a (qualora questo fosse stato scelto rispetto al modello bifactor) ammette
# una struttura sovraordinata. 
# Ispezioniamo la matrice Phi stimata:
lavInspect(object = fit_hc1_a_a,what = "std")$psi
# La matrice Phi stimata non evidenzia correlazioni elevate tra le variabili latenti. In questo caso, una struttura di ordine superiore potrebbe non essere
# necessaria. Valutiamola comunque a scopi didattici:

mod_hc1_so = "eta1 =~ First.Letters+Sentences+Four.Letter.Words+Suffixes+Letter.Series+Letter.Group \n 
eta2 =~ Vocabulary+Sent.Completion+Pedigrees+Sentences \n
eta0 =~ eta1+eta2"

fit_hc1_so = cfa(model = mod_hc1_so,data = datay_B)
lavaan_checkConvergence(fit_hc1_so)
summary(fit_hc1_so)
# La versione sovra-ordinata del mdello hc1_a_a non ha convergenza.
# Non procediamo oltre con questo modello.
# Qualora la scelta fosse dunque tra il modello mod_hc1_so e hc1_a_a dovremmo procedere con quest'ultimo data la non convergenza del modello sovra-ordinato 
# costruito a partire da quest'ultimo.















