#######################################################################
## Testing psicologico (PSP6075525)
### Modelli e metodi statistici per la misurazione in psicologia
## A.A. 2023/2024
## prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################################


## CONTENUTO DEL CODICE ###############################################
# (A) Calcolo di probabilità di eventi aleatori
# (B) Rappresentazioni grafiche descrittive dei dati
#######################################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2023_2024/testing_psicologico/laboratorio/") #change it according to your local path!



# (A) Calcolo di probabilità di eventi aleatori ---------------------------

## I Esempio (caso v.a. discreta)
# Sapendo che Anna svolgerà un test psicologico di 20 items con modalità di risposta 
# dicotomica, siamo interessati a calcolare qual è la probabilità che risponderà 
# correttamente a un certo numero di items sapendo che la probabilità che risponda correttamente 
# ad un singolo item è 0.3.

xsup = seq(1,30) #supporto osservato v.a. discreta
plot(xsup,dbinom(x = xsup,size = 20,prob = 0.30),bty="n",type = "h") #densità discreta v.a. Binomiale

# Evento di interesse: X=13 (numero di items a cui Anna risponderà correttamente)
abline(v = 13,col=2) #X=13
dbinom(13,20,0.3) #P[X=13]

# Evento di interesse: X<=5 (Anna risponderà correttamente al massimo a 5 items)
sum(dbinom(1:5,20,0.3)) #P[X<=5]
pbinom(5,20,.3) #se si usa la funzione di ripartizione della v.a.

# Evento di interesse: X>=5 (Anna risponderà correttamente almeno a 5 items)
sum(dbinom(6:30,20,0.3)) #P[X>=5]
1-pbinom(5,20,.3) #se si usa la funzione di ripartizione della v.a.


## II Esempio (caso v.a. discreta)
# Sapendo che in media i clienti in un supermercato sono 7/h
# qual è la probabilità che si osservi un affluenza di 11/h ?

xsup = seq(0,30) #supporto osservato v.a. discreta
plot(xsup,dpois(x = xsup,lambda = 7),bty="n",type = "h") #densità discreta v.a. Poisson

# Evento di interesse: X=11
abline(v = 11,col=2)
dpois(11,7)

#Evento di interesse: X<=6 (afflunza di al massimo 6 clienti in un'ora)
sum(dpois(1:6,7))
ppois(6,7)

## III Esempio (caso v.a. continua)
# Si prevede che la temperatura rilevata giornalmente alle ore 12.00 in una data città
# sia mediamente di 20°, sapendo che le rilevazioni e le temperature sono caratterizzate
# da una certa variabilità, si assume che le rilevazioni giornaliere siano delle 
# realizzazioni di una variabile casuale Y distribuita normalmente con parametri 
# mu= 20 e sigma=5
# Qual è la probabilità che ad una singola rilevazione la temperatura registrata sia 
# maggiore di 25°? 
# Con quale probabilità la rilevazione sarà compresa tra 17° e 23°? 

curve(dnorm(x,20,5),from = -5,to = 40,bty="n")

# Evento di interesse: X>25
abline(v = 25,col=2)
integrate(f = function(x)dnorm(x,20,5),25,Inf)$val #P[X>25]
1-pnorm(25,20,5) # 1-P[X<25]

# Evento di interesse: X in [17,23]
curve(dnorm(x,20,5),from = -5,to = 40,bty="n")
abline(v = c(17,23),col=2)
integrate(f = function(x)dnorm(x,20,5),17,23)$val #P[X>17 & X<23]
pnorm(23,20,5) - pnorm(17,20,5)  # P[X<23]-P[X<17]

## IV esempio (caso v.a. continua)
curve(dchisq(x,2),from = 0,to = 10,bty="n")

# Evento di interesse: X>4
abline(v = 4,col=2)
integrate(f = function(x)dchisq(x,2),4,Inf)$val #P[X>4]
1-pchisq(4,2) # 1-P[X<4]

## V esempio (caso v.a. continua p-dimensionale)

#p=2
S = diag(2)*1.5                 #matrice di covarianza (no covariazione)
m = matrix(0,nrow = 1,ncol = 2) #vettore di medie

x1sup=seq(from=-4,to=4,length=101) #supporto I v.a. normale
x2sup=seq(from=-4,to=4,length=101) #supporto II va.a. normale

funx = function(x,y){mvtnorm::dmvnorm(cbind(x,y),mean=m,sigma = S)} #funzione calcolo densità congiunta
fx = outer(x1sup, x2sup, funx) #calcolo densità congiunta per ciascuna coppia (x1,x2)

x11();par(mfrow=c(1,3)) #nuova finestra grafica + divisione in 3 sottofinestre
plot(x1sup,dnorm(x1sup,m[1],S[1,1]),bty="n",type="l") #grafico densità marginale I
plot(x2sup,dnorm(x2sup,m[2],S[2,2]),bty="n",type="l") #grafico densità marginale II
persp(x1sup,x2sup,fx,theta = 10, phi = 20, expand = 0.5, col = "lightblue") #grafico densità congiunta
x11(); filled.contour(x1sup,x2sup,fx) #grafico curve di livello della densità congiunta

#p=2
S = matrix(c(1.5,0.9,0.9,1.5),nrow = 2,ncol = 2) #matrice di covarianza (con covariazione positiva)
fx = outer(x1sup, x2sup, funx) #calcolo densità congiunta per ciascuna coppia (x1,x2)

x11();par(mfrow=c(1,3)) #nuova finestra grafica + divisione in 3 sottofinestre
plot(x1sup,dnorm(x1sup,m[1],S[1,1]),bty="n",type="l") #grafico densità marginale I
plot(x2sup,dnorm(x2sup,m[2],S[2,2]),bty="n",type="l") #grafico densità marginale II
persp(x1sup,x2sup,fx,theta = 10, phi = 20, expand = 0.5, col = "lightblue") #grafico densità congiunta
x11(); filled.contour(x1sup,x2sup,fx) #grafico curve di livello della densità congiunta



# (B) Rappresentazioni grafiche descrittive dei dati ----------------------

## Generiamo dei dati continui e categoriali
n = 100                                 #numerosità campionaria
set.seed(881)
S = clusterGeneration::rcorrmatrix(d=5) #generiamo casualmente una matrice di correlazione per le vars continue 
X = mvtnorm::rmvnorm(n = 100,sigma = S) #5 vars continue con media zero correlate secondo S
z = rbinom(n = n,size = 1,prob = 0.6)   #variabile dicotomica
datax = data.frame(X,z)
datax$z = factor(x = datax$z,labels = c("A","B"))
head(datax)
str(datax)

## Rappresentazione marginale delle variabili
x11(); par(mfrow=c(2,3))
hist(datax$X1); hist(datax$X2); hist(datax$X3); hist(datax$X4); hist(datax$X5)
barplot(table(datax$z),main = "barplot of z")

## Rappresentazione condizionata rispetto ad una variabile categoriale
x11(); par(mfrow=c(1,2))
hist(datax$X1[datax$z=="A"]); hist(datax$X1[datax$z=="B"])
plot(density(datax$X1[datax$z=="A"]),ylim=c(0,0.45),bty="n",main=""); lines(density(datax$X1[datax$z=="B"]),col=2)
boxplot(datax$X2~z) 

## Rappresentazione bivariata 
x11(); plot(x = datax$X1,y = datax$X2,bty="n"); 

## Rappresentazione bivariata condizionata
x11()
plot(x = datax$X1[datax$z=="A"],y = datax$X2[datax$z=="A"],bty="n",pch=20,col=2,lwd=2)
points(x = datax$X1[datax$z=="B"],y = datax$X2[datax$z=="B"],bty="n",pch=20,col=4,lwd=2)



