#######################################################################
## Testing psicologico (PSP6075525)
### Modelli e metodi statistici per la misurazione in psicologia
## A.A. 2023/2024
## prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################################


## CONTENUTO DEL CODICE ###############################################
# (A) Item analysis e reliability (caso dicotomico)
# (B) Item analysis e reliability (caso politomico)
#######################################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2023_2024/testing_psicologico/laboratorio/") #change it according to your local path!
source("utilities.R")
library(psych)


# (A) Item analysis e reliability (caso dicotomico) -----------------------

## Dataset
datax = read.csv(file = "data/mobility.csv",sep = ",",header = TRUE) #the "file" parameter must be changed using your own data directory
# The dataset "datax" contains a rural subsample of 8445 women from the Bangladesh Fertility Survey of 1989. The dimension of interest is women's mobility of social freedom. 
# Women were asked whether they could engage in the following activities alone (1 = yes, 0 = no):
# Item 1: Go to any part of the village/town/city.
# Item 2: Go outside the village/town/city.
# Item 3: Talk to a man you do not know.
# Item 4: Go to a cinema/cultural show.
# Item 5: Go shopping.
# Item 6: Go to a cooperative/mothers' club/other club.
# Item 7: Attend a political meeting.
# Item 8: Go to a health centre/hospital.
# Get more info by typing ?ltm::Mobility (you need to install the R package "ltm" first)

## Prime visualizzazioni della struttura dei dati
str(datax)
head(datax)

## Statistiche descrittive e grafiche
describe(datax)

x11();par(mfrow=c(2,4))
for(j in 1:8){
  barplot(table(datax[,j]),main = colnames(datax)[j]) #distribuzioni di frequenza per ciascun item 
}

# Proporzioni di SI=1/NO=0 per ciascun item
# Usiamo la funzione apply() per il calcolo senza usare il ciclo for()
datax.prop = apply(X = datax,MARGIN = 2,FUN = table)
datax.prop = prop.table(x = datax.prop,margin = 2) #margin=2 allows columns/items to sum 1
print(datax.prop)

# Calcoliamo un indice di eterogeneità per variabili categoriali (mutabili), ad esempio 
# l'indice di entropia normalizzata Hj = -sum(fi*log(fi))/log(2). Nota: log(2) permette di normalizzare l'indice, 2 è il numero di categorie (item dicotomici)
# Usiamo la funzione apply() per il calcolo senza usare il ciclo for()
datax.H = apply(X = datax.prop,MARGIN = 2,FUN = function(x){-sum(x*log(x))/log(length(x))}) #in questo caso FUN specifica una funzione ad-hoc da noi definita, ossia la funzione di entropia: H(x) = -sum(x)*log(x)/log(length(x)) dove length(x)=2 in questo caso
print(datax.H)
# notiamo come gli item 5 e 7 presentano bassa entropia: le frequenze di risposte sono difatti concentrate su una sola delle due categorie. Nota: H(x)=1 (max entropia) quando f(x=0)=0.5 e f(x=1)=0.5 (dist uniforme sulle due categorie)

par(mfrow=c(1,1)) #ri-settiamo una sola finestra grafica
plot(x = 1:8,y = datax.H,type="b",bty="n",ylim = c(0,1));abline(h = 0.5,col=2,lty=2)


## Reliability
kr20(datax) # attendibilità complessiva utilizzando l'indice KR20 per item dicotomici

# Valutiamo come cambia l'indice KR20 se eliminiamo, uno alla volta, un item dal test
datax.kr20.removed = matrix(NA,nrow = 8,ncol = 2) # per salvare i risultati del ciclo for()
colnames(datax.kr20.removed) = c("KR20","item dropped") #intestazioni di colonna della matrice dei risultati
for(j in 1:8){
  datax.kr20.removed[j,1] = kr20(datax[,-j]) #calcolo del KR20 senza l'item j
  datax.kr20.removed[j,2] = j #item scartato
}
print(datax.kr20.removed)
plot(x = datax.kr20.removed[,2],y = datax.kr20.removed[,1],ylim=c(0.7,0.8),bty="n",type="b")
abline(h = kr20(datax),col=2,lty=2) #kr20 complessivo 


# Attendibilità complessiva utilizzando la procedura Split-Half
split_half(data = datax,type = "alternate") # divisione per item pari e dispari (type="alternate")
split_half(data = datax,type = "random") # divisione per item casuale
# Il risultato del coeff di attendibilità calcolato mediante type="random" potrà subire fluttuazioni dipendenti dal tipo di suddivisione casuale realizzata


## Nota: un output dettagliato e unico per l'analisi descrittiva degli item e l'analisi dell'attendibilità può anche essere ottenuta 
## utilizzando le funzioni descript() o scoreItems() delle librerie, rispettivamente, ltm e psych. Ad esempio, rispetto al dataset dicotomico finora utilizzato:
datax.all1 = ltm::descript(data = datax,chi.squared = FALSE)
print(datax.all1)

datax.all2 = psych::scoreItems(keys = rep(1,8),items = datax,totals = TRUE)
print(datax.all2)
str(datax.all2)



# (B) Item analysis e reliability (caso politomico) -----------------------

# Utilizziamo il dataset 'bfi' (pacchetto psych) che contiene 25 items presi dal test IPIP (International Personality Item Pool, http:\\ipip.ori.org) per la quantificazione
# dei 5 fattori di personalità Agreeableness (A), Conscientiousness (C), Extraversion (E), Neuroticism (N), and Opennness (O). Il dataset contiene anche 3 variabili ulteriori di classificazione
# (gender, education, age). Per maggiori info: bfi.dictionary

data("bfi") #importazione dei dati dalla libreria psych al workspace corrente di R

# Prime visualizzazioni dei dati
str(bfi) 
head(bfi)

# Analisi dei valori mancanti nel dataset
num.na = apply(bfi,2,function(x)sum(is.na(x))) #conta il numero di NAs per ciascuna colonna (variabile) del dataset
barplot(num.na[1:25],horiz = TRUE) #grafico a barre degli NA's per gli items
barplot(num.na[26:28],horiz = TRUE) #grafico a barre degli NA's per le variabili di classificazione

# Gli items non contengono molti valori mancanti rispetto al totale di unità statistiche. La sola variabile che contiene molti valori mancanti è 'education'. 
# Se usiamo l'esclusione row-wise (default di R) che elimina le righe che hanno almeno un NA su una variabile perderemmo NROW(bfi)-NROW(na.omit(bfi))=564 unità.
# Se al contrario escludiamo la variabile 'education' perderemmo NROW(bfi[,-27])-NROW(na.omit(bfi[,-27]))=364 unità. Sebbene la differenza non sia così elevata
# procediamo escludendo la variabile 'education'.
bfi = bfi[,-27]

# Statistiche descrittive e grafiche
describe(x = bfi) #complessive
describeBy(x = bfi,group = "gender") #per livelli della variabile di classificazione 'gender'

x11();par(mfrow=c(5,5))
for(j in 1:25){
  barplot(table(bfi[,j]),main = colnames(bfi)[j]) #distribuzioni di frequenza per ciascun item 
}

# Abbiamo usato barplot() e non hist() poiché le osservabili sono rilevate a livello ordinale con scale a 6 livelli. Possiamo notare come le distribuzioni tendono ad 
# essere poco simmetriche ed alcuni items (es.: C5,N4) tendono ad avere distribuzioni prossime a quella uniforme (tutte i livelli della scala sono scelti dai soggetti).

# Calcoliamo un indice di eterogeneità per variabili categoriali (mutabili), ad esempio l'indice di entropia normalizzata Hj = -sum(fi*log(fi))/log(6)
Y = matrix(NA,25,6+1) #25 items x 6 livelli della scala + 1 entropia
for(j in 1:25){
  fi = table(bfi[,j])/NROW(bfi[,j])  
  Hj = -sum(fi*log(fi))/log(6)
  Y[j,1:6] = fi #prime 6 colonne: frequenze per ciascun livello della scala
  Y[j,7] = Hj #ultima colonna: entropia normalizzata
}
Y=data.frame(Y); colnames(Y)[7] = "H"

plot(Y$H,type="b", bty="n",xlab="item",ylab="entropia normalizzata",ylim=c(0.7,1))
abline(h=mean(Y$H),lty=2)

iid=which(Y$H>mean(Y$H)) #items che hanno entropia norm. sopra la media (indice dell'intem)
names(bfi)[iid] #items che hanno entropia norm. sopra la media (nome dell'item)

# Visualizziamo la distribuzione degli items per gender
x11();par(mfrow=c(5,5))
for(j in 1:25){
  bi.bars(bfi,names(bfi)[j],"gender",ylab=names(bfi)[j])
}


## Reliability
# Il test IPIP contiene cinque scale ognuna con cinque items. Per valutare la coerenza interna delle singole scale (attendibilità) dobbiamo dapprima
# verificare la presenza di "reversed items", ossia items che presentano inversione di scala rispetto agli altri (un item con scala invertita, ad esempio, è un item
# dove il primo livello corrisponde all'estremo superiore mentre l'ultimo livello all'estremo inferiore). Spesso questi tipi di items sono utilizzati per evitare
# l'effetto faking, di manipolazione della risposta, o come items di controllo. 
# Tale informazione è disponibile nell'oggetto bfi.keys denotato dal segno "-" (indicante item reversed)
print(bfi.keys)

# Possiamo usare alcune funzioni della libreria psych per codificare gli items
bfi.omit = na.omit(bfi) #psych non elimina i dati mancanti row-wise ma gli sostituisce con la mediana delle osservazioni

keys.list = list(agree=c("-A1","A2","A3","A4","A5"), #lista contenente le scale con i relativi items (il segno "-" indica che l'item è rovesciato)
                 conscientious=c("C1","C2","C3","-C4","-C5"),
                 extraversion=c("-E1","-E2","E3","E4","E5"),
                 neuroticism=c("-N1","-N2","N3","-N4","-N5"), 
                 openness = c("O1","-O2","O3","O4","-O5")) 

bfi.keys = make.keys(bfi.omit,keys.list) #crea una matrice di indici con gli items rovesciati

scores = scoreItems(keys = bfi.keys,items = bfi.omit,min=1,max=6)  #per info vedi scoreItems() 
print(scores)

# La funzione scoreItems() calcola diverse quantità utili all'analisi della coerenza interna secondo la TCT:
# alpha di Cronbach per ciascuna scala (con errore standard dell'indice)
# correlazione media e mediana degli items con la scala
# indice di attendibilità di Guttman e rapporto segnale rumore
# Correlazioni tra scale corrette per attenuazione:
## Correlations between scales are attenuated by a lack of reliability. 
## Correcting correlations for reliability (by dividing by the square roots of the reliabilities of each scale) sometimes help show structure. 
## This is done in the scale intercorrelation matrix with raw correlations below the diagonal and unattenuated correlation above the diagonal.









