#######################################################################
## Testing psicologico (PSP6075525)
### Modelli e metodi statistici per la misurazione in psicologia
## A.A. 2023/2024
## prof. Antonio Calcagnì (antonio.calcagni@unipd.it)
#######################################################################


## CONTENUTO DEL CODICE ###############################################
# (A) Descrizione del dataset
# (B) Modelli CFA
# (C) Confronto e valutazione
#######################################################################


# Inizializzazione ambiente di lavoro -------------------------------------
rm(list=ls()); graphics.off()
setwd("~/MEGA/Lavoro_sync/Didattica/2023_2024/testing_psicologico/laboratorio/") #change it according to your local path!
library(lavaan); library(semPlot)
source("utilities.R")


# (A) Descrizione del dataset ---------------------------------------------
# Source: https://lhbikos.github.io/ReC_Psychometrics/CFA2nd.html

# Keum et al’s Gendered Racial Microaggressions Scale for Asian American Women (GRMSAAW: Keum et al., 2018)
# There are 22 items on the GRMSAAW scale. The frequency scaling ranged included: 0(never), 1 (rarely), 2(sometimes), 3(often), 4(very frequently), and 5(always)
# The four factors are as follows:
# Ascribed Submissiveness: items abbreviated as “AS#”
# Asian Fetishism: items abbreviated as “AF#”
# Media Invalidation: items abbreviated as “MI#”
# Assumptions of Universal Appearance: items abbreviated as “UA#”
load("data/data_keum18.Rdata")

## Controllo ed eventuale ricodifica vars categoriali 
str(data_keum18)
data_keum18 = as.factor_dataframe(X = data_keum18,type = "all",ordered=TRUE)
str(data_keum18)


# (B) Modelli CFA ---------------------------------------------------------

## Nota: I modelli che seguono presentano problemi di convergenza, in alcuni casi trascurabili (es.: model2_fit) in 
## altri casi invece non ignorabili (es.: model0_fit). Per ragioni didattiche legate a questo laboratorio, trascureremo questi errori
## e tratteremo i modelli come se avessero avto convergenza.

## Modello a quattro dimensioni ortogonali
model0  =   "AS =~ AS1 + AS2 + AS3 + AS4 + AS5 + AS6 + AS7 + AS8 + AS9
             AF =~ AF1 + AF2 + AF3 + AF4 
             MI =~ MI1 + MI2 + MI3 + MI4 + MI5
             AUA =~ AUA1 + AUA2 + AUA3 + AUA4"

model0_fit = lavaan::cfa(model = model0, data = data_keum18, orthogonal = TRUE,ordered = colnames(data_keum18),estimator="DWLS")
#lavaan_checkConvergence(model0_fit) 
#summary(model0_fit) #attenzione: varianze d'errore negative!

## Modello a quattro dimensioni non ortogonali
model1_fit = lavaan::cfa(model = model0, data = data_keum18, orthogonal = FALSE,ordered = colnames(data_keum18),estimator="DWLS")
#lavaan_checkConvergence(model1_fit) 
#summary(model1_fit)

## Modello sovraordinato
model2  =   "AS =~ AS1 + AS2 + AS3 + AS4 + AS5 + AS6 + AS7 + AS8 + AS9
             AF =~ AF1 + AF2 + AF3 + AF4 
             MI =~ MI1 + MI2 + MI3 + MI4 + MI5
             AUA =~ AUA1 + AUA2 + AUA3 + AUA4
             GRMS =~ AS + AF + MI + AUA"

model2_fit = lavaan::cfa(model = model2, data = data_keum18, orthogonal = FALSE,ordered = colnames(data_keum18),estimator="DWLS")
#lavaan_checkConvergence(model2_fit)

## Modello bi-factor
model3  =   "GRMS =~ AS1 + AS2 + AS3 + AS4 + AS5 + AS6 + AS7 + AS8 + AS9 + AF1 + AF2 + AF3 + AF4 + MI1 + MI2 + MI3 + MI4 + MI5 + AUA1 + AUA2 + AUA3 + AUA4

             AS =~ AS1 + AS2 + AS3 + AS4 + AS5 + AS6 + AS7 + AS8 + AS9
             AF =~ AF1 + AF2 + AF3 + AF4 
             MI =~ MI1 + MI2 + MI3 + MI4 + MI5
             AUA =~ AUA1 + AUA2 + AUA3 + AUA4
             
            GRMS ~~ 0*AS
            GRMS ~~ 0*AF
            GRMS ~~ 0*MI
            GRMS ~~ 0*AUA
            
            AS ~~ l1*AF
            AS ~~ l2*MI
            AS ~~ l3*AUA
            AF ~~ l4*MI
            AF ~~ l5*AUA
            MI ~~ l6*AUA"

#eliminamo il vincolo di ortogonalità completo per favorire la convergenza dell'algoritmo
model3_fit = lavaan::cfa(model = model3, data = data_keum18, orthogonal = FALSE,ordered = colnames(data_keum18),estimator="DWLS")


# (C) Confronto e valutazione ---------------------------------------------

fitmeasures(object = model0_fit,fit.measures = c("npar","cfi","rmsea","rmsea.ci.lower","rmsea.ci.upper","srmr"))
#Results
# Non-significant chi-square: No
# CFI ≥ 0.95: Sì
# RMSEA ≤ 0.05 (but definitely < 0.10): No
# SRMR ≤ 0.08 (but definitely < .10): No
# Combination rule CFI ≥ 0.95 & SRMR ≤ 0.08: No

fitmeasures(object = model1_fit,fit.measures = c("npar","cfi","rmsea","rmsea.ci.lower","rmsea.ci.upper","srmr"))
#Results
# Non-significant chi-square: No
# CFI ≥ 0.95: Sì
# RMSEA ≤ 0.05 (but definitely < 0.10): No
# SRMR ≤ 0.08 (but definitely < .10): No
# Combination rule CFI ≥ 0.95 & SRMR ≤ 0.08: No

anova(model0_fit,model1_fit,test="Chisq")
#If it is statistically significant, the better model is the one with the lower chi-square value (and better fit indices)

fitmeasures(object = model2_fit,fit.measures = c("npar","cfi","rmsea","rmsea.ci.lower","rmsea.ci.upper","srmr"))
#Results
# Non-significant chi-square: No
# CFI ≥ 0.95: Sì
# RMSEA ≤ 0.05 (but definitely < 0.10): No
# SRMR ≤ 0.08 (but definitely < .10): No
# Combination rule CFI ≥ 0.95 & SRMR ≤ 0.08: No

anova(model0_fit,model2_fit,test="Chisq")

fitmeasures(object = model3_fit,fit.measures = c("npar","cfi","rmsea","rmsea.ci.lower","rmsea.ci.upper","srmr"))
#Results
# Non-significant chi-square: No
# CFI ≥ 0.95: Sì
# RMSEA ≤ 0.05 (but definitely < 0.10): Sì
# SRMR ≤ 0.08 (but definitely < .10): Sì
# Combination rule CFI ≥ 0.95 & SRMR ≤ 0.08: No

anova(model2_fit,model3_fit,test="Chisq")

summary(model3_fit,standardized = TRUE)
out = lavInspect(object = model3_fit,what = "std")
BifactorIndicesCalculator::cat_Omega_H(Lambda = out$lambda,Phi = out$psi,Thresh = out$tau)
BifactorIndicesCalculator::cat_Omega_S(Lambda = out$lambda,Phi = out$psi,Thresh = out$tau)
BifactorIndicesCalculator::ECV_GS(Lambda = out$lambda)
BifactorIndicesCalculator::ECV_SS(Lambda = out$lambda)








